/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.shared.utils;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.common.filesystem.HostAwareFile;
import ch.systemsx.cisd.common.filesystem.IFreeSpaceProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.utils.SharesHolder;
import ch.systemsx.cisd.openbis.generic.shared.dto.SimpleDataSetInformationDTO;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;

public final class Share {
    public static final Comparator<SimpleDataSetInformationDTO> DATA_SET_SIZE_COMPARATOR = new Comparator<SimpleDataSetInformationDTO>(){

        @Override
        public int compare(SimpleDataSetInformationDTO o1, SimpleDataSetInformationDTO o2) {
            long size2;
            long size1 = o1.getDataSetSize();
            return size1 < (size2 = o2.getDataSetSize().longValue()) ? 1 : (size1 > size2 ? -1 : 0);
        }
    };
    private final SharesHolder sharesHolderOrNull;
    private final File share;
    private final IFreeSpaceProvider freeSpaceProvider;
    private final String shareId;
    private final int speed;
    private final List<SimpleDataSetInformationDTO> dataSets = new ArrayList<SimpleDataSetInformationDTO>();
    private boolean areDataSetsSorted;
    private boolean incoming;
    private long size;
    private ShufflePriority shufflePriority = ShufflePriority.SPEED;
    private boolean withdrawShare;
    private boolean unarchivingScratchShare;
    private long unarchivingScratchShareMaximumSize;
    private boolean ignoredForShuffling;
    private Set<String> experimentIdentifiers;
    private Set<String> dataSetTypes;

    public Share(File share, int speed, IFreeSpaceProvider freeSpaceProvider) {
        this(null, share, speed, freeSpaceProvider);
    }

    public Share(SharesHolder sharesHolderOrNull, File share, int speed, IFreeSpaceProvider freeSpaceProvider) {
        this.sharesHolderOrNull = sharesHolderOrNull;
        this.share = share;
        this.speed = speed;
        this.freeSpaceProvider = freeSpaceProvider;
        this.shareId = share.getName();
    }

    public Set<String> getExperimentIdentifiers() {
        return this.experimentIdentifiers;
    }

    public void setExperimentIdentifiers(Set<String> experimentIdentifiers) {
        this.experimentIdentifiers = experimentIdentifiers;
    }

    public Set<String> getDataSetTypes() {
        return this.dataSetTypes;
    }

    public void setDataSetTypes(Set<String> dataSetTypes) {
        this.dataSetTypes = dataSetTypes;
    }

    public String getShareId() {
        return this.shareId;
    }

    public int getSpeed() {
        return this.speed;
    }

    public void setIncoming(boolean incoming) {
        this.incoming = incoming;
    }

    public boolean isIncoming() {
        return this.incoming;
    }

    public File getShare() {
        return this.share;
    }

    public long calculateFreeSpace() {
        try {
            return 1024L * this.freeSpaceProvider.freeSpaceKb(new HostAwareFile(this.share));
        }
        catch (IOException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary((Exception)ex);
        }
    }

    public void addDataSet(SimpleDataSetInformationDTO dataSet) {
        this.dataSets.add(dataSet);
        this.size += dataSet.getDataSetSize().longValue();
    }

    public List<SimpleDataSetInformationDTO> getDataSetsOrderedBySize() {
        if (this.sharesHolderOrNull != null) {
            this.sharesHolderOrNull.addDataSetsToStores();
        }
        if (!this.areDataSetsSorted) {
            Collections.sort(this.dataSets, DATA_SET_SIZE_COMPARATOR);
            this.areDataSetsSorted = true;
        }
        return this.dataSets;
    }

    public long getTotalSizeOfDataSets() {
        if (this.sharesHolderOrNull != null) {
            this.sharesHolderOrNull.addDataSetsToStores();
        }
        return this.size;
    }

    public ShufflePriority getShufflePriority() {
        return this.shufflePriority;
    }

    public void setShufflePriority(ShufflePriority shufflePriority) {
        this.shufflePriority = shufflePriority;
    }

    public boolean isWithdrawShare() {
        return this.withdrawShare;
    }

    public void setWithdrawShare(boolean withdrawShare) {
        this.withdrawShare = withdrawShare;
    }

    public boolean isUnarchivingScratchShare() {
        return this.unarchivingScratchShare;
    }

    public void setUnarchivingScratchShare(boolean unarchivingScratchShare) {
        this.unarchivingScratchShare = unarchivingScratchShare;
    }

    public long getUnarchivingScratchShareMaximumSize() {
        return this.unarchivingScratchShareMaximumSize;
    }

    public void setUnarchivingScratchShareMaximumSize(long unarchivingScratchShareMaximumSize) {
        this.unarchivingScratchShareMaximumSize = unarchivingScratchShareMaximumSize;
    }

    public boolean isIgnoredForShuffling() {
        return this.ignoredForShuffling;
    }

    public void setIgnoredForShuffling(boolean ignoredForShuffling) {
        this.ignoredForShuffling = ignoredForShuffling;
    }

    public static enum ShufflePriority {
        SPEED,
        MOVE_TO_EXTENSION;

    }
}

