/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.imagereaders.bioformats;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.base.exceptions.IOExceptionUnchecked;
import ch.systemsx.cisd.imagereaders.ImageID;
import ch.systemsx.cisd.imagereaders.bioformats.BioFormatsImageProcessor;
import ij.ImagePlus;
import ij.ImageStack;
import ij.process.ImageProcessor;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import loci.common.IRandomAccess;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.formats.FormatException;
import loci.formats.FormatHandler;
import loci.formats.IFormatHandler;
import loci.formats.IFormatReader;
import loci.formats.ImageReader;
import loci.formats.MetadataTools;
import loci.formats.codec.ZlibCodec;
import loci.formats.gui.BufferedImageReader;
import loci.formats.in.CellomicsReader;
import loci.formats.in.DefaultMetadataOptions;
import loci.formats.in.MetadataLevel;
import loci.formats.in.MetadataOptions;

final class BioFormatsImageUtils {
    private static final IFormatReader[] READERS = new ImageReader().getReaders();

    static {
        MetadataTools.setDefaultDateEnabled((boolean)false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IFormatReader tryToCreateReaderForFile(String fileName) {
        IFormatReader[] iFormatReaderArray = READERS;
        synchronized (READERS) {
            IFormatReader[] iFormatReaderArray2 = READERS;
            int n = READERS.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return null;
                }
                IFormatReader reader = iFormatReaderArray2[n2];
                try {
                    if (reader.isThisType(fileName)) {
                        IFormatReader iFormatReader = BioFormatsImageUtils.createReader(reader.getClass());
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return iFormatReader;
                    }
                }
                finally {
                    BioFormatsImageUtils.closeOpenedFiles(reader);
                }
                ++n2;
            }
        }
    }

    private static void closeOpenedFiles(IFormatReader r) {
        try {
            r.close(true);
        }
        catch (IOException ex) {
            throw new IOExceptionUnchecked(ex);
        }
    }

    public static IFormatReader tryToCreateReaderByName(String readerName) throws IllegalArgumentException {
        Class[] classArray = ImageReader.getDefaultReaderClasses().getClasses();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class clazz = classArray[n2];
            if (clazz.getSimpleName().equals(readerName)) {
                return BioFormatsImageUtils.createReader(clazz);
            }
            ++n2;
        }
        return null;
    }

    private static IFormatReader createReader(Class<? extends IFormatReader> clazz) throws Error {
        try {
            return clazz.newInstance();
        }
        catch (InstantiationException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary((Throwable)ex.getCause());
        }
        catch (IllegalAccessException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary((Exception)ex);
        }
    }

    public static List<String> getReaderNames() {
        ArrayList<String> readerNames = new ArrayList<String>(READERS.length);
        IFormatReader[] iFormatReaderArray = READERS;
        int n = READERS.length;
        int n2 = 0;
        while (n2 < n) {
            IFormatReader reader = iFormatReaderArray[n2];
            String readerName = BioFormatsImageUtils.getReaderName(reader);
            readerNames.add(readerName);
            ++n2;
        }
        return readerNames;
    }

    public static String getReaderName(IFormatReader reader) {
        return reader.getClass().getSimpleName();
    }

    static List<ImageID> listImageIDs(IFormatReader reader, IRandomAccess handle) {
        String handleId = BioFormatsImageUtils.generateHandleId((IFormatHandler)reader, null);
        Location.mapFile((String)handleId, (IRandomAccess)handle);
        try {
            reader.setId(handleId);
            ArrayList<ImageID> ids = new ArrayList<ImageID>();
            int seriesCount = reader.getSeriesCount();
            int s = 0;
            while (s < seriesCount) {
                reader.setSeries(s);
                int effectiveSizeC = reader.getEffectiveSizeC();
                int sizeT = reader.getSizeT();
                int sizeZ = reader.getSizeZ();
                int t = 0;
                while (t < sizeT) {
                    int z = 0;
                    while (z < sizeZ) {
                        int c = 0;
                        while (c < effectiveSizeC) {
                            ids.add(new ImageID(s, t, z, c));
                            ++c;
                        }
                        ++z;
                    }
                    ++t;
                }
                ++s;
            }
            BioFormatsImageUtils.close(reader);
            ArrayList<ImageID> arrayList = ids;
            return arrayList;
        }
        catch (Exception ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary((Exception)ex);
        }
        finally {
            Location.mapFile((String)handleId, null);
        }
    }

    static BufferedImage readImage(IFormatReader reader, IRandomAccess handle, ImageID imageID) throws IOExceptionUnchecked, IllegalArgumentException {
        String handleId = BioFormatsImageUtils.generateHandleId((IFormatHandler)reader, imageID);
        Location.mapFile((String)handleId, (IRandomAccess)handle);
        try {
            reader.setId(handleId);
            reader.setSeries(imageID.getSeriesIndex());
            BufferedImageReader biReader = BufferedImageReader.makeBufferedImageReader((IFormatReader)reader);
            int index = BioFormatsImageUtils.calculateImageIndex(reader, imageID);
            BufferedImage image = biReader.openImage(index);
            BioFormatsImageUtils.close(reader);
            BufferedImage bufferedImage = image;
            return bufferedImage;
        }
        catch (FormatException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary((Exception)((Object)ex));
        }
        catch (IOException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary((Exception)ex);
        }
        finally {
            Location.mapFile((String)handleId, null);
        }
    }

    private static void close(IFormatReader reader) throws IOException {
        reader.close();
    }

    private static int calculateImageIndex(IFormatReader reader, ImageID imageID) {
        return reader.getIndex(imageID.getFocalPlaneIndex(), imageID.getColorChannelIndex(), imageID.getTimeSeriesIndex());
    }

    public static Map<String, Object> readMetadata(IFormatReader reader, IRandomAccess handle, ImageID imageID) {
        String handleId = BioFormatsImageUtils.generateHandleId((IFormatHandler)reader, imageID);
        Location.mapFile((String)handleId, (IRandomAccess)handle);
        try {
            HashMap<String, Object> result = new HashMap<String, Object>();
            DefaultMetadataOptions metaOptions = new DefaultMetadataOptions(MetadataLevel.ALL);
            reader.setMetadataOptions((MetadataOptions)metaOptions);
            reader.setId(handleId);
            reader.setSeries(imageID.getSeriesIndex());
            BioFormatsImageUtils.nullSafeAddAll(result, reader.getGlobalMetadata());
            BioFormatsImageUtils.nullSafeAddAll(result, reader.getSeriesMetadata());
            BioFormatsImageUtils.close(reader);
            HashMap<String, Object> hashMap = result;
            return hashMap;
        }
        catch (Exception ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary((Exception)ex);
        }
        finally {
            Location.mapFile((String)handleId, null);
        }
    }

    static BufferedImage readImageWithIntensityRescaling(IFormatReader reader, IRandomAccess handle, ImageID imageID, int channel) throws IOExceptionUnchecked, IllegalArgumentException {
        String handleId = BioFormatsImageUtils.generateHandleId((IFormatHandler)reader, imageID);
        Location.mapFile((String)handleId, (IRandomAccess)handle);
        try {
            reader.setId(handleId);
            reader.setSeries(imageID.getSeriesIndex());
            int width = reader.getSizeX();
            int height = reader.getSizeY();
            ImageStack stack = new ImageStack(width, height);
            int imageIndex = BioFormatsImageUtils.calculateImageIndex(reader, imageID);
            ImageProcessor ip = BioFormatsImageProcessor.openProcessor(reader, imageIndex, channel);
            stack.addSlice("", ip);
            ImagePlus imp = new ImagePlus(handleId, stack);
            BufferedImage image = imp.getBufferedImage();
            BioFormatsImageUtils.close(reader);
            BufferedImage bufferedImage = image;
            return bufferedImage;
        }
        catch (FormatException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary((Exception)((Object)ex));
        }
        catch (IOException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary((Exception)ex);
        }
        finally {
            Location.mapFile((String)handleId, null);
        }
    }

    static Dimension readImageDimensions(IFormatReader reader, IRandomAccess handle, ImageID imageID) throws IOExceptionUnchecked, IllegalArgumentException {
        String handleId = BioFormatsImageUtils.generateHandleId((IFormatHandler)reader, imageID);
        Location.mapFile((String)handleId, (IRandomAccess)handle);
        try {
            if (reader instanceof CellomicsReader) {
                Dimension dimension = CellomicsReaderUtil.readSize(handleId);
                return dimension;
            }
            reader.setId(handleId);
            reader.setSeries(imageID.getSeriesIndex());
            int width = reader.getSizeX();
            int height = reader.getSizeY();
            BioFormatsImageUtils.close(reader);
            Dimension dimension = new Dimension(width, height);
            return dimension;
        }
        catch (FormatException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary((Exception)((Object)ex));
        }
        catch (IOException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary((Exception)ex);
        }
        finally {
            Location.mapFile((String)handleId, null);
        }
    }

    static Integer readImageColorDepth(IFormatReader reader, IRandomAccess handle, ImageID imageID) throws IOExceptionUnchecked, IllegalArgumentException {
        String handleId = BioFormatsImageUtils.generateHandleId((IFormatHandler)reader, imageID);
        Location.mapFile((String)handleId, (IRandomAccess)handle);
        try {
            reader.setId(handleId);
            reader.setSeries(imageID.getSeriesIndex());
            int depth = reader.getBitsPerPixel();
            BioFormatsImageUtils.close(reader);
            Integer n = depth;
            return n;
        }
        catch (FormatException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary((Exception)((Object)ex));
        }
        catch (IOException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary((Exception)ex);
        }
        finally {
            Location.mapFile((String)handleId, null);
        }
    }

    public static String generateHandleId(IFormatHandler formatHandler, ImageID imageId) {
        String id = String.valueOf(UUID.randomUUID().toString()) + "." + formatHandler.getSuffixes()[0];
        if (imageId != null && imageId.getFileName() != null) {
            id = imageId.getFileName();
        }
        return id;
    }

    private static void nullSafeAddAll(HashMap<String, Object> accumulator, Hashtable<String, Object> toAdd) {
        if (toAdd != null) {
            accumulator.putAll(toAdd);
        }
    }

    private BioFormatsImageUtils() {
    }

    public static class CellomicsReaderUtil {
        public static Dimension readSize(String id) throws FormatException, IOException {
            RandomAccessInputStream in = CellomicsReaderUtil.getDecompressedStream(id);
            in.order(true);
            in.skipBytes(4);
            int x = in.readInt();
            int y = in.readInt();
            in.close();
            return new Dimension(x, y);
        }

        private static RandomAccessInputStream getDecompressedStream(String filename) throws FormatException, IOException {
            RandomAccessInputStream s = new RandomAccessInputStream(filename);
            if (FormatHandler.checkSuffix((String)filename, (String)"c01")) {
                s.seek(4L);
                ZlibCodec codec = new ZlibCodec();
                byte[] file = codec.decompress(s, null);
                s.close();
                return new RandomAccessInputStream(file);
            }
            return s;
        }
    }
}

