/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.imagereaders.bioformats;

import ch.systemsx.cisd.imagereaders.IImageReader;
import ch.systemsx.cisd.imagereaders.IReadParams;
import ch.systemsx.cisd.imagereaders.ImageID;
import ch.systemsx.cisd.imagereaders.ReadParams;
import ch.systemsx.cisd.imagereaders.bioformats.BioFormatsReaderLibrary;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FileDialog;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;

public class BioFormatsImageViewer {
    public static void main(String[] args) {
        String[] myArgs = args;
        if (myArgs.length == 0) {
            FileDialog fileDialog = new FileDialog(null);
            fileDialog.setMode(0);
            fileDialog.setVisible(true);
            String dir = fileDialog.getDirectory();
            myArgs = new String[]{String.valueOf(dir) + "/" + fileDialog.getFile()};
        }
        String[] stringArray = myArgs;
        int n = myArgs.length;
        int n2 = 0;
        while (n2 < n) {
            String fileName = stringArray[n2];
            IImageReader reader = new BioFormatsReaderLibrary().tryGetReaderForFile(fileName);
            System.out.println("=========== File: " + fileName);
            System.out.println("Reader: " + reader);
            System.out.println("Library: " + reader.getLibraryName());
            System.out.println("Name: " + reader.getName());
            File file = new File(fileName);
            ReadParams readParams = new ReadParams();
            readParams.setIntensityRescalingChannel(0);
            List<ImageID> imageIDs = reader.getImageIDs(file);
            ArrayList<BufferedImage> images = new ArrayList<BufferedImage>();
            for (ImageID imageID : imageIDs) {
                System.out.println(imageID);
                BufferedImage image = reader.readImage(file, imageID, (IReadParams)readParams);
                images.add(image);
            }
            BioFormatsImageViewer.showImages(images, fileName);
            ++n2;
        }
    }

    private static void showImages(List<BufferedImage> images, String fileName) {
        JFrame frame = new JFrame("Images: " + fileName);
        Container contentPane = frame.getContentPane();
        JPanel mainPanel = new JPanel(new BorderLayout());
        contentPane.add(mainPanel);
        int size = images.size();
        if (size > 1) {
            JTabbedPane tabbedPane = new JTabbedPane();
            mainPanel.add((Component)tabbedPane, "Center");
            int i = 0;
            while (i < size) {
                BufferedImage image = images.get(i);
                String tabName = Integer.toString(i);
                tabbedPane.addTab(tabName, BioFormatsImageViewer.createImagePanel(image));
                ++i;
            }
        } else {
            mainPanel.add(BioFormatsImageViewer.createImagePanel(images.get(0)), "Center");
        }
        frame.setLocationByPlatform(true);
        frame.pack();
        frame.setVisible(true);
    }

    private static Component createImagePanel(BufferedImage image) {
        return new JScrollPane(new JLabel(new ImageIcon(image)));
    }
}

