/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.imagereaders.bioformats;

import ch.systemsx.cisd.imagereaders.bioformats.BioFormatsImageUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import loci.formats.IFormatReader;

public class BioFormatsInfo {
    private static final int CUTTOFF = 50;

    public static void main(String[] args) throws Exception {
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String fileName = stringArray[n2];
            IFormatReader reader = BioFormatsImageUtils.tryToCreateReaderForFile(fileName);
            if (reader == null) {
                System.out.println("No image reader found for " + fileName);
            } else {
                reader.setId(fileName);
                System.out.println("====== " + fileName);
                System.out.println(" format: " + reader.getFormat());
                System.out.println(" image count: " + reader.getImageCount());
                System.out.println(" bits per pixel: " + reader.getBitsPerPixel());
                System.out.println(" dimension order: " + reader.getDimensionOrder());
                System.out.println(" size T: " + reader.getSizeT());
                System.out.println(" size X: " + reader.getSizeX());
                System.out.println(" size Y: " + reader.getSizeY());
                System.out.println(" size Z: " + reader.getSizeZ());
                System.out.println(" size C: " + reader.getSizeC());
                System.out.println(" effective size C: " + reader.getEffectiveSizeC());
                System.out.println(" pixel type: " + reader.getPixelType());
                System.out.println(" RGB channel count: " + reader.getRGBChannelCount());
                List coreMetadata = reader.getCoreMetadataList();
                System.out.println(" # of core meta-data: " + coreMetadata.size());
                BioFormatsInfo.printMap("  global meta-data", reader.getGlobalMetadata());
                int seriesCount = reader.getSeriesCount();
                System.out.println(" series count: " + seriesCount);
                int i = 0;
                while (i < Math.min(2, seriesCount)) {
                    reader.setSeries(i);
                    BioFormatsInfo.printMap(" series meta-data " + i, reader.getSeriesMetadata());
                    ++i;
                }
            }
            ++n2;
        }
    }

    private static void printMap(String title, Map<String, Object> map) {
        System.out.println(String.valueOf(title) + ":");
        ArrayList<Map.Entry<String, Object>> entries = new ArrayList<Map.Entry<String, Object>>(map.entrySet());
        Collections.sort(entries, new Comparator<Map.Entry<String, Object>>(){

            @Override
            public int compare(Map.Entry<String, Object> o1, Map.Entry<String, Object> o2) {
                return o1.getKey().compareTo(o2.getKey());
            }
        });
        for (Map.Entry entry : entries) {
            String value = entry.getValue().toString();
            if (value.length() > 50) {
                value = String.valueOf(value.substring(0, 50)) + "...";
            }
            System.out.println("     " + (String)entry.getKey() + " = " + value);
        }
    }
}

