/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.imagereaders.bioformats;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.base.exceptions.IOExceptionUnchecked;
import ch.systemsx.cisd.base.io.IRandomAccessFile;
import ch.systemsx.cisd.imagereaders.AbstractMetaDataAwareImageReader;
import ch.systemsx.cisd.imagereaders.IReadParams;
import ch.systemsx.cisd.imagereaders.ImageID;
import ch.systemsx.cisd.imagereaders.ReadParams;
import ch.systemsx.cisd.imagereaders.bioformats.BioFormatsImageUtils;
import ch.systemsx.cisd.imagereaders.bioformats.BioFormatsRandomAccessAdapter;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import loci.formats.IFormatReader;

class DefaultBioformatsImageReader
extends AbstractMetaDataAwareImageReader {
    private final IFormatReader formatReader;
    private final boolean singleImagePerFile;

    DefaultBioformatsImageReader(String libraryName, String readerName, IFormatReader formatReader, boolean singleImagePerFile) {
        super(libraryName, readerName);
        this.formatReader = formatReader;
        this.singleImagePerFile = singleImagePerFile;
    }

    @Override
    public List<ImageID> getImageIDs(IRandomAccessFile handle) throws IOExceptionUnchecked {
        if (this.singleImagePerFile) {
            return super.getImageIDs(handle);
        }
        BioFormatsRandomAccessAdapter input = new BioFormatsRandomAccessAdapter(handle);
        return BioFormatsImageUtils.listImageIDs(this.formatReader, input);
    }

    @Override
    public BufferedImage readImage(IRandomAccessFile handle, ImageID imageID, IReadParams params) throws IOExceptionUnchecked {
        Integer intensityRescalingChannel = null;
        ReadParams readParams = (ReadParams)params;
        if (readParams != null) {
            intensityRescalingChannel = readParams.getIntensityRescalingChannel();
        }
        BioFormatsRandomAccessAdapter input = new BioFormatsRandomAccessAdapter(handle);
        if (intensityRescalingChannel != null) {
            return BioFormatsImageUtils.readImageWithIntensityRescaling(this.formatReader, input, imageID, intensityRescalingChannel);
        }
        return BioFormatsImageUtils.readImage(this.formatReader, input, imageID);
    }

    @Override
    public Map<String, Object> readMetaData(IRandomAccessFile handle, ImageID imageID, IReadParams params) throws IOExceptionUnchecked {
        BioFormatsRandomAccessAdapter input = new BioFormatsRandomAccessAdapter(handle);
        return BioFormatsImageUtils.readMetadata(this.formatReader, input, imageID);
    }

    @Override
    public Dimension readDimensions(IRandomAccessFile handle, ImageID imageID) {
        BioFormatsRandomAccessAdapter input = new BioFormatsRandomAccessAdapter(handle);
        return BioFormatsImageUtils.readImageDimensions(this.formatReader, input, imageID);
    }

    @Override
    public Integer readColorDepth(IRandomAccessFile handle, ImageID imageID) {
        BioFormatsRandomAccessAdapter input = new BioFormatsRandomAccessAdapter(handle);
        return BioFormatsImageUtils.readImageColorDepth(this.formatReader, input, imageID);
    }

    @Override
    public void close() {
        try {
            this.formatReader.close();
        }
        catch (IOException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary((Exception)ex);
        }
    }

    protected void finalize() throws Throwable {
        this.close();
    }
}

