/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.AbstractDateValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.AbstractFieldSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.DateEarlierThanOrEqualToValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.DateEarlierThanValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.DateEqualToValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.DateLaterThanOrEqualToValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.DateLaterThanValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.DateObjectEarlierThanOrEqualToValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.DateObjectEarlierThanValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.DateObjectEqualToValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.DateObjectLaterThanOrEqualToValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.DateObjectLaterThanValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.IDate;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.IDateFormat;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.ITimeZone;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.LongDateFormat;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.NormalDateFormat;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.SearchFieldType;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.ServerTimeZone;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.ShortDateFormat;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.TimeZone;
import ch.systemsx.cisd.base.annotation.JsonObject;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@JsonObject(value="as.dto.common.search.DateFieldSearchCriteria")
public abstract class DateFieldSearchCriteria
extends AbstractFieldSearchCriteria<IDate> {
    @JsonIgnore
    public static final ShortDateFormat SHORT_DATE_FORMAT = new ShortDateFormat();
    @JsonIgnore
    public static final NormalDateFormat NORMAL_DATE_FORMAT = new NormalDateFormat();
    @JsonIgnore
    public static final LongDateFormat LONG_DATE_FORMAT = new LongDateFormat();
    @JsonIgnore
    public static final List<IDateFormat> DATE_FORMATS = new ArrayList<IDateFormat>();
    private static final long serialVersionUID = 1L;
    private ITimeZone timeZone = new ServerTimeZone();

    protected DateFieldSearchCriteria(String fieldName, SearchFieldType fieldType) {
        super(fieldName, fieldType);
    }

    public void thatEquals(Date date) {
        this.setFieldValue(new DateObjectEqualToValue(date));
    }

    public void thatEquals(String date) {
        this.setFieldValue(new DateEqualToValue(date));
    }

    public void thatIsLaterThanOrEqualTo(Date date) {
        this.setFieldValue(new DateObjectLaterThanOrEqualToValue(date));
    }

    public void thatIsLaterThanOrEqualTo(String date) {
        this.setFieldValue(new DateLaterThanOrEqualToValue(date));
    }

    public void thatIsLaterThan(Date date) {
        this.setFieldValue(new DateObjectLaterThanValue(date));
    }

    public void thatIsLaterThan(String date) {
        this.setFieldValue(new DateLaterThanValue(date));
    }

    public void thatIsEarlierThanOrEqualTo(Date date) {
        this.setFieldValue(new DateObjectEarlierThanOrEqualToValue(date));
    }

    public void thatIsEarlierThanOrEqualTo(String date) {
        this.setFieldValue(new DateEarlierThanOrEqualToValue(date));
    }

    public void thatIsEarlierThan(Date date) {
        this.setFieldValue(new DateObjectEarlierThanValue(date));
    }

    public void thatIsEarlierThan(String date) {
        this.setFieldValue(new DateEarlierThanValue(date));
    }

    public DateFieldSearchCriteria withServerTimeZone() {
        this.timeZone = new ServerTimeZone();
        return this;
    }

    public DateFieldSearchCriteria withTimeZone(int hourOffset) {
        this.timeZone = new TimeZone(hourOffset);
        return this;
    }

    public void setTimeZone(ITimeZone timeZone) {
        this.timeZone = timeZone;
    }

    public ITimeZone getTimeZone() {
        return this.timeZone;
    }

    @Override
    public void setFieldValue(IDate value) {
        DateFieldSearchCriteria.checkValueFormat(value);
        super.setFieldValue(value);
    }

    private static void checkValueFormat(IDate value) {
        if (value instanceof AbstractDateValue) {
            for (IDateFormat dateFormat : DATE_FORMATS) {
                if (DateFieldSearchCriteria.formatValue((String)((AbstractDateValue)value).getValue(), dateFormat) == null) continue;
                return;
            }
            throw new IllegalArgumentException("Date value: " + value + " does not match any of the supported formats: " + DATE_FORMATS);
        }
    }

    @JsonIgnore
    public static Date formatValue(String value, IDateFormat dateFormat) {
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(dateFormat.getFormat());
            simpleDateFormat.setLenient(false);
            return simpleDateFormat.parse(value);
        }
        catch (ParseException e) {
            return null;
        }
    }

    static {
        DATE_FORMATS.add(LONG_DATE_FORMAT);
        DATE_FORMATS.add(NORMAL_DATE_FORMAT);
        DATE_FORMATS.add(SHORT_DATE_FORMAT);
    }
}

