/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.asapi.v3.dto.webapp;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.webapp.WebAppSetting;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.webapp.fetchoptions.WebAppSettingsFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.exceptions.NotFetchedException;
import ch.systemsx.cisd.base.annotation.JsonObject;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.Map;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@JsonObject(value="as.dto.webapp.WebAppSettings")
public class WebAppSettings
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty
    private WebAppSettingsFetchOptions fetchOptions;
    @JsonProperty
    private String webAppId;
    @JsonProperty
    private Map<String, WebAppSetting> settings;

    @JsonIgnore
    public WebAppSettingsFetchOptions getFetchOptions() {
        return this.fetchOptions;
    }

    public void setFetchOptions(WebAppSettingsFetchOptions fetchOptions) {
        this.fetchOptions = fetchOptions;
    }

    @JsonIgnore
    public String getWebAppId() {
        return this.webAppId;
    }

    public void setWebAppId(String webAppId) {
        this.webAppId = webAppId;
    }

    @JsonIgnore
    public WebAppSetting getSetting(String setting) {
        if (this.getFetchOptions() != null && (this.getFetchOptions().hasAllSettings() || this.getFetchOptions().hasSetting(setting))) {
            return this.settings != null ? this.settings.get(setting) : null;
        }
        throw new NotFetchedException("Setting '" + setting + "' has not been fetched.");
    }

    @JsonIgnore
    public Map<String, WebAppSetting> getSettings() {
        if (this.getFetchOptions() != null && (this.getFetchOptions().hasAllSettings() || this.getFetchOptions().getSettings() != null && !this.getFetchOptions().getSettings().isEmpty())) {
            return this.settings;
        }
        throw new NotFetchedException("Settings have not been fetched.");
    }

    public void setSettings(Map<String, WebAppSetting> settings) {
        this.settings = settings;
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE);
        builder.append((Object)this.webAppId);
        builder.append(this.settings);
        return builder.toString();
    }
}

