/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.collection;

import ch.systemsx.cisd.common.collection.IKeyExtractor;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class TableMap<K, E>
implements Iterable<E> {
    private final Map<K, E> map = new LinkedHashMap<K, E>();
    private final IKeyExtractor<K, E> extractor;
    private final UniqueKeyViolationStrategy uniqueKeyViolationStrategy;

    public TableMap(IKeyExtractor<K, E> extractor) {
        this(null, extractor, UniqueKeyViolationStrategy.ERROR);
    }

    public TableMap(IKeyExtractor<K, E> extractor, UniqueKeyViolationStrategy uniqueKeyViolationStrategy) {
        this(null, extractor, uniqueKeyViolationStrategy);
    }

    public TableMap(Iterable<E> rows, IKeyExtractor<K, E> extractor) {
        this(rows, extractor, UniqueKeyViolationStrategy.ERROR);
    }

    public TableMap(Iterable<E> rowsOrNull, IKeyExtractor<K, E> extractor, UniqueKeyViolationStrategy uniqueKeyViolationStrategy) {
        assert (extractor != null) : "Unspecified key extractor.";
        assert (uniqueKeyViolationStrategy != null) : "Unspecified unique key violation strategy.";
        this.extractor = extractor;
        this.uniqueKeyViolationStrategy = uniqueKeyViolationStrategy;
        if (rowsOrNull != null) {
            for (E row : rowsOrNull) {
                this.add(row);
            }
        }
    }

    public final void add(E row) throws UniqueKeyViolationException {
        K key = this.extractor.getKey(row);
        if (this.uniqueKeyViolationStrategy == UniqueKeyViolationStrategy.KEEP_LAST || this.map.get(key) == null) {
            this.map.put(key, row);
        } else if (this.uniqueKeyViolationStrategy == UniqueKeyViolationStrategy.ERROR) {
            throw new UniqueKeyViolationException(key);
        }
    }

    public final E getOrDie(K key) {
        E elem = this.tryGet(key);
        if (elem == null) {
            throw new IllegalStateException("No value for the specified key found: " + key);
        }
        return elem;
    }

    public final E tryGet(K key) {
        return this.map.get(key);
    }

    public final Collection<E> values() {
        return Collections.unmodifiableCollection(this.map.values());
    }

    public final Set<K> keySet() {
        return Collections.unmodifiableSet(this.map.keySet());
    }

    public E remove(K key) {
        E row = this.map.remove(key);
        if (row == null) {
            throw new IllegalArgumentException("Couldn't remove row for key '" + key + "' because there was no row.");
        }
        return row;
    }

    public final String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    @Override
    public final Iterator<E> iterator() {
        return new Iterator<E>(){
            private Iterator<Map.Entry<K, E>> iterator;
            {
                this.iterator = TableMap.this.map.entrySet().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public E next() {
                return this.iterator.next().getValue();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Can not remove an element.");
            }
        };
    }

    public static class UniqueKeyViolationException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
        private final Object invalidKey;

        UniqueKeyViolationException(Object invalidKey) {
            super("Key '" + invalidKey.toString() + "' already in the map.");
            this.invalidKey = invalidKey;
        }

        public Object getInvalidKey() {
            return this.invalidKey;
        }
    }

    public static enum UniqueKeyViolationStrategy {
        KEEP_FIRST,
        KEEP_LAST,
        ERROR;

    }
}

