/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.collection;

import ch.systemsx.cisd.common.collection.CompositeValidator;
import ch.systemsx.cisd.common.collection.IValidator;
import ch.systemsx.cisd.common.collection.RegExValidator;
import java.util.regex.Pattern;

public final class ValidatorUtils {
    private static final IValidator<Object> NOT_NULL_VALIDATOR = new IValidator<Object>(){

        @Override
        public final boolean isValid(Object object) {
            return object != null;
        }
    };
    private static final IValidator<Object> ALWAYS_TRUE = new IValidator<Object>(){

        @Override
        public final boolean isValid(Object object) {
            return true;
        }
    };

    private ValidatorUtils() {
    }

    public static final IValidator<String> createCaseInsensitivePatternValidator(String[] patterns) {
        assert (patterns != null) : "Unspecified patterns.";
        int length = patterns.length;
        switch (length) {
            case 0: {
                return null;
            }
            case 1: {
                return ValidatorUtils.createCaseInsensitivePatternValidator(patterns[0]);
            }
        }
        CompositeValidator<String> validator = new CompositeValidator<String>();
        for (String pattern : patterns) {
            validator.addValidator(ValidatorUtils.createCaseInsensitivePatternValidator(pattern));
        }
        return validator;
    }

    public static final IValidator<String> createCaseInsensitivePatternValidator(String pattern) {
        if (pattern == null) {
            return null;
        }
        Pattern regEx = Pattern.compile(ValidatorUtils.convertToRegEx(pattern), 2);
        return new RegExValidator(regEx);
    }

    public static final <T> IValidator<T> getNotNullValidator() {
        return NOT_NULL_VALIDATOR;
    }

    public static final <T> IValidator<T> getAlwaysTrueValidator() {
        return ALWAYS_TRUE;
    }

    static final String convertToRegEx(String pattern) {
        assert (pattern != null);
        StringBuilder stringBuilder = new StringBuilder();
        char[] chars = pattern.toCharArray();
        boolean escape = false;
        for (char c : chars) {
            String toAppend;
            if (c == '\\') {
                escape = true;
                toAppend = c + "";
            } else if (c == '?' || c == '*') {
                if (!escape) {
                    toAppend = ".";
                    if (c == '*') {
                        toAppend = toAppend + "*";
                    }
                } else {
                    toAppend = c + "";
                    escape = false;
                }
            } else {
                toAppend = c + "";
                escape = false;
            }
            stringBuilder.append(toAppend);
        }
        return stringBuilder.toString();
    }
}

