/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.fileconverter;

import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.base.exceptions.InterruptedExceptionUnchecked;
import ch.systemsx.cisd.common.concurrent.ParallelizedExecutor;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.fileconverter.FileConversionTaskExecutor;
import ch.systemsx.cisd.common.fileconverter.IFileConversionStrategy;
import ch.systemsx.cisd.common.filesystem.FileUtilities;
import ch.systemsx.cisd.common.logging.ISimpleLogger;
import ch.systemsx.cisd.common.logging.Log4jSimpleLogger;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.logging.LogInitializer;
import java.io.File;
import java.io.FileFilter;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;

public class FileConverter {
    @Private
    static final int MAX_RETRY_OF_FAILED_COMPRESSIONS = 3;
    private static final Logger machineLog;

    private static List<File> tryGetFilesToProcess(File directory, final IFileConversionStrategy conversionStrategy) {
        return FileUtilities.listFiles(directory, new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return conversionStrategy.tryCheckConvert(pathname) != null;
            }
        }, true, null, (ISimpleLogger)new Log4jSimpleLogger(machineLog));
    }

    public static String performConversion(File directory, IFileConversionStrategy conversionStrategy, double machineLoad, int maxThreads) throws InterruptedExceptionUnchecked, EnvironmentFailureException {
        conversionStrategy.getConverter().check();
        List<File> itemsToProcess = FileConverter.tryGetFilesToProcess(directory, conversionStrategy);
        FileConversionTaskExecutor taskExecutor = new FileConversionTaskExecutor(conversionStrategy);
        Collection failureReport = ParallelizedExecutor.process(itemsToProcess, taskExecutor, machineLoad, maxThreads, "File conversion", 3, false);
        return ParallelizedExecutor.tryFailuresToString(failureReport);
    }

    private FileConverter() {
    }

    static {
        LogInitializer.init();
        machineLog = LogFactory.getLogger(LogCategory.MACHINE, FileConverter.class);
    }
}

