/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.filesystem;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.base.exceptions.TimeoutExceptionUnchecked;
import ch.systemsx.cisd.common.concurrent.ITimerTaskStatusProvider;
import ch.systemsx.cisd.common.filesystem.DirectoryScannedStore;
import ch.systemsx.cisd.common.filesystem.FaultyPathDirectoryScanningHandler;
import ch.systemsx.cisd.common.filesystem.IDirectoryScanningHandler;
import ch.systemsx.cisd.common.filesystem.IPathHandler;
import ch.systemsx.cisd.common.filesystem.IStoreHandler;
import ch.systemsx.cisd.common.filesystem.PathHandlerAdapter;
import ch.systemsx.cisd.common.filesystem.StoreItem;
import ch.systemsx.cisd.common.logging.ConditionalNotificationLogger;
import ch.systemsx.cisd.common.logging.ISimpleLogger;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TimerTask;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public final class DirectoryScanningTimerTask
extends TimerTask
implements ITimerTaskStatusProvider {
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, DirectoryScanningTimerTask.class);
    private static final Logger notificationLog = LogFactory.getLogger(LogCategory.NOTIFY, DirectoryScanningTimerTask.class);
    private final IStoreHandler storeHandler;
    private final IScannedStore sourceDirectory;
    private final IDirectoryScanningHandler directoryScanningHandler;
    private final ConditionalNotificationLogger notificationLogger;
    private final Map<StoreItem, String> errorLog;
    private boolean didSomeWork;
    private String threadNameOrNull;
    private File activityLogDirectoryOrNull;
    private volatile boolean stopRun;

    public DirectoryScanningTimerTask(File sourceDirectory, FileFilter filter, IPathHandler handler, IDirectoryScanningHandler directoryScanningHandler, String threadName, File activityLogDirectory) {
        this(DirectoryScanningTimerTask.asScannedStore(sourceDirectory, filter), directoryScanningHandler, PathHandlerAdapter.asScanningHandler(sourceDirectory, handler), 0, threadName, activityLogDirectory);
    }

    public DirectoryScanningTimerTask(File sourceDirectory, FileFilter filter, IPathHandler handler, IDirectoryScanningHandler directoryScanningHandler) {
        this(DirectoryScanningTimerTask.asScannedStore(sourceDirectory, filter), directoryScanningHandler, PathHandlerAdapter.asScanningHandler(sourceDirectory, handler), 0, null, null);
    }

    public DirectoryScanningTimerTask(IScannedStore scannedStore, IDirectoryScanningHandler directoryScanningHandler, IStoreHandler storeHandler, int ignoredErrorCount) {
        this(scannedStore, directoryScanningHandler, storeHandler, ignoredErrorCount, null, null);
    }

    public DirectoryScanningTimerTask(File sourceDirectory, FileFilter filter, IStoreHandler storeHandler, IDirectoryScanningHandler directoryScanningHandler) {
        this(DirectoryScanningTimerTask.asScannedStore(sourceDirectory, filter), directoryScanningHandler, storeHandler, 0, null, null);
    }

    public DirectoryScanningTimerTask(File sourceDirectory, FileFilter filter, IPathHandler pathHandler) {
        this(sourceDirectory, filter, pathHandler, 0);
    }

    public DirectoryScanningTimerTask(File sourceDirectory, FileFilter filter, IPathHandler pathHandler, String threadName, File activityLogDirectory) {
        this(sourceDirectory, filter, pathHandler, 0, threadName, activityLogDirectory);
    }

    public DirectoryScanningTimerTask(IScannedStore scannedStore, IDirectoryScanningHandler directoryScanningHandler, IStoreHandler storeHandler, int ignoredErrorCount, String threadName, File activityLogDirectory) {
        assert (scannedStore != null);
        assert (storeHandler != null);
        assert (directoryScanningHandler != null) : "Unspecified IDirectoryScanningHandler implementation";
        assert (ignoredErrorCount >= 0);
        this.sourceDirectory = scannedStore;
        this.storeHandler = storeHandler;
        this.directoryScanningHandler = directoryScanningHandler;
        this.notificationLogger = new ConditionalNotificationLogger(operationLog, (Priority)Level.WARN, notificationLog, ignoredErrorCount);
        this.errorLog = new LinkedHashMap<StoreItem, String>();
        this.threadNameOrNull = threadName;
        this.activityLogDirectoryOrNull = activityLogDirectory;
        if (activityLogDirectory != null && !activityLogDirectory.isDirectory()) {
            activityLogDirectory.mkdirs();
            if (!activityLogDirectory.isDirectory()) {
                operationLog.error((Object)("Cannot create activityLogDirectory " + activityLogDirectory + " - activity logging disabled."));
            }
        }
    }

    DirectoryScanningTimerTask(File sourceDirectory, FileFilter fileFilter, IPathHandler pathHandler, int ignoredErrorCount) {
        this(DirectoryScanningTimerTask.asScannedStore(sourceDirectory, fileFilter), new FaultyPathDirectoryScanningHandler(sourceDirectory, pathHandler, null), PathHandlerAdapter.asScanningHandler(sourceDirectory, pathHandler), ignoredErrorCount, null, null);
    }

    DirectoryScanningTimerTask(File sourceDirectory, FileFilter fileFilter, IPathHandler pathHandler, int ignoredErrorCount, String threadName, File activityLogDirectory) {
        this(DirectoryScanningTimerTask.asScannedStore(sourceDirectory, fileFilter), new FaultyPathDirectoryScanningHandler(sourceDirectory, pathHandler, null), PathHandlerAdapter.asScanningHandler(sourceDirectory, pathHandler), ignoredErrorCount, threadName, activityLogDirectory);
    }

    private static final IScannedStore asScannedStore(File directory, FileFilter filter) {
        return new DirectoryScannedStore(filter, directory);
    }

    private final void printNotification(Exception ex) {
        if (ex instanceof TimeoutExceptionUnchecked) {
            notificationLog.error((Object)("Timeout while scanning directory: " + ex.getMessage()), (Throwable)ex);
        } else {
            notificationLog.error((Object)"An exception has occurred. (thread still running)", (Throwable)CheckedExceptionTunnel.unwrapIfNecessary(ex));
        }
    }

    private final StoreItem[] listStoreItems() {
        StoreItem[] storeItems = this.sourceDirectory.tryListSorted(this.notificationLogger);
        if (storeItems != null) {
            this.notificationLogger.reset(String.format("Directory '%s' is available again.", this.sourceDirectory));
        }
        return storeItems == null ? StoreItem.EMPTY_ARRAY : storeItems;
    }

    public final void stopRun() {
        this.stopRun = true;
    }

    /*
     * Exception decompiling
     */
    @Override
    public final void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[DOLOOP]], but top level block is 27[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void logActivity() {
        if (this.activityLogDirectoryOrNull != null) {
            File activityFile = new File(this.activityLogDirectoryOrNull, this.threadNameOrNull.replace(' ', '_'));
            try {
                FileUtils.touch((File)activityFile);
            }
            catch (IOException ex) {
                operationLog.warn((Object)("Cannot touch activity file " + activityFile));
            }
        }
    }

    private void cleanseErrorLog(StoreItem[] allStoreItemsOrNull) {
        if (allStoreItemsOrNull == null) {
            return;
        }
        HashSet<StoreItem> itemSet = new HashSet<StoreItem>(Arrays.asList(allStoreItemsOrNull));
        for (StoreItem errorItem : new ArrayList<StoreItem>(this.errorLog.keySet())) {
            if (itemSet.contains(errorItem)) continue;
            this.errorLog.remove(errorItem);
        }
    }

    private String getDefaultErrorMessage(StoreItem storeItem) {
        return String.format("Error processing item '%s'.", storeItem);
    }

    @Override
    public boolean hasErrors() {
        return this.errorLog.size() > 0;
    }

    @Override
    public boolean hasPerformedMeaningfulWork() {
        return this.didSomeWork;
    }

    @Override
    public String tryGetErrorLog() {
        if (this.hasErrors()) {
            return String.format("  [%s]\n  %s", StringUtils.defaultIfEmpty((CharSequence)this.threadNameOrNull, (CharSequence)"UNKNOWN"), StringUtils.join(this.errorLog.values(), (String)"\n  "));
        }
        return null;
    }

    public static interface IScannedStore {
        public StoreItem[] tryListSorted(ISimpleLogger var1);

        public StoreItem[] tryFilterReadyToProcess(StoreItem[] var1, ISimpleLogger var2);

        public boolean existsOrError(StoreItem var1);

        public String getLocationDescription(StoreItem var1);

        public File asFile(StoreItem var1) throws UnsupportedOperationException;

        public StoreItem asStoreItem(String var1);
    }
}

