/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.filesystem;

import ch.systemsx.cisd.base.exceptions.IOExceptionUnchecked;
import ch.systemsx.cisd.base.utilities.OSUtilities;
import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.common.filesystem.CopyModeExisting;
import ch.systemsx.cisd.common.filesystem.FastHardLinkMaker;
import ch.systemsx.cisd.common.filesystem.HardLinkMaker;
import ch.systemsx.cisd.common.filesystem.IDirectoryImmutableCopier;
import ch.systemsx.cisd.common.filesystem.IFileImmutableCopier;
import ch.systemsx.cisd.common.filesystem.IImmutableCopier;
import ch.systemsx.cisd.common.filesystem.RecursiveHardLinkMaker;
import ch.systemsx.cisd.common.filesystem.rsync.RsyncBasedRecursiveHardLinkMaker;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.time.TimingParameters;
import java.io.File;
import java.util.List;
import org.apache.log4j.Logger;

public class FastRecursiveHardLinkMaker
implements IImmutableCopier {
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, FastRecursiveHardLinkMaker.class);
    private static final String RSYNC_EXEC = "rsync";
    private static final String LN_EXEC = "ln";
    private static final int DEFAULT_MAX_ERRORS_TO_IGNORE = 3;
    private final IImmutableCopier fallbackCopierOrNull;
    private final IFileImmutableCopier internFileCopierOrNull;
    private final IDirectoryImmutableCopier rsyncBasedDirectoryCopierOrNull;

    public static final IImmutableCopier tryCreate(List<String> additionalCmdLineFlagsOrNull) {
        return FastRecursiveHardLinkMaker.tryCreate(TimingParameters.getDefaultParameters(), additionalCmdLineFlagsOrNull);
    }

    public static final IImmutableCopier tryCreate(TimingParameters timingParameters, List<String> additionalCmdLineFlagsOrNull) {
        File rsyncExecOrNull = OSUtilities.findExecutable(RSYNC_EXEC);
        File lnExecOrNull = OSUtilities.findExecutable(LN_EXEC);
        try {
            return FastRecursiveHardLinkMaker.create(rsyncExecOrNull, lnExecOrNull, timingParameters, false, additionalCmdLineFlagsOrNull);
        }
        catch (ConfigurationFailureException ex) {
            return null;
        }
    }

    public static final IImmutableCopier create(File rsyncExecutable, File lnExecutable, List<String> additionalCmdLineFlagsOrNull) {
        return FastRecursiveHardLinkMaker.create(rsyncExecutable, lnExecutable, TimingParameters.getDefaultParameters(), false, additionalCmdLineFlagsOrNull);
    }

    public static final IImmutableCopier create(File rsyncExecutable, File lnExecutable, TimingParameters parameters, List<String> additionalCmdLineFlagsOrNull) {
        return new FastRecursiveHardLinkMaker(rsyncExecutable, lnExecutable, parameters, false, additionalCmdLineFlagsOrNull);
    }

    public static final IImmutableCopier create(File rsyncExecutable, File lnExecutable, TimingParameters parameters, boolean neverUseNative, List<String> additionalCmdLineFlagsOrNull) {
        return new FastRecursiveHardLinkMaker(rsyncExecutable, lnExecutable, parameters, neverUseNative, additionalCmdLineFlagsOrNull);
    }

    private FastRecursiveHardLinkMaker(File rsyncExcutable, File lnExecutable, TimingParameters timingParameters, boolean neverUseNative, List<String> additionalCmdLineFlagsOrNull) throws ConfigurationFailureException {
        this.internFileCopierOrNull = neverUseNative ? null : FastHardLinkMaker.tryCreate(timingParameters);
        this.rsyncBasedDirectoryCopierOrNull = rsyncExcutable == null ? null : new RsyncBasedRecursiveHardLinkMaker(rsyncExcutable, timingParameters, 3, additionalCmdLineFlagsOrNull);
        this.fallbackCopierOrNull = this.internFileCopierOrNull == null ? RecursiveHardLinkMaker.tryCreate(HardLinkMaker.create(lnExecutable, timingParameters)) : RecursiveHardLinkMaker.tryCreate(this.internFileCopierOrNull);
        if (this.internFileCopierOrNull == null && this.fallbackCopierOrNull == null || this.rsyncBasedDirectoryCopierOrNull == null && this.fallbackCopierOrNull == null) {
            throw new ConfigurationFailureException("FastRecursiveHardLinkMaker not operational");
        }
        if (operationLog.isInfoEnabled()) {
            operationLog.info((Object)timingParameters.toString());
            if (this.internFileCopierOrNull != null) {
                operationLog.info((Object)"Using native library to create hard link copies of files.");
            } else {
                operationLog.info((Object)"Using 'ln' to create hard link copies of files.");
            }
            if (this.rsyncBasedDirectoryCopierOrNull != null) {
                operationLog.info((Object)"Using 'rsync' to traverse directories when making recursive hard link copies.");
            } else {
                operationLog.info((Object)"Using Java to traverse directories when making recursive hard link copies");
            }
        }
    }

    @Override
    public Status copyImmutably(File source, File destinationDirectory, String nameOrNull) {
        return this.copyImmutably(source, destinationDirectory, nameOrNull, CopyModeExisting.ERROR);
    }

    @Override
    public Status copyImmutably(File source, File destinationDirectory, String nameOrNull, CopyModeExisting mode) {
        if (source.isDirectory()) {
            File target = FastRecursiveHardLinkMaker.getTarget(source, destinationDirectory, nameOrNull, mode);
            if (!(this.rsyncBasedDirectoryCopierOrNull == null || mode == CopyModeExisting.OVERWRITE && target.exists())) {
                return this.rsyncBasedDirectoryCopierOrNull.copyDirectoryImmutably(source, destinationDirectory, nameOrNull, mode);
            }
            return this.fallbackCopierOrNull.copyImmutably(source, destinationDirectory, nameOrNull, mode);
        }
        if (this.internFileCopierOrNull != null) {
            return this.internFileCopierOrNull.copyFileImmutably(source, destinationDirectory, nameOrNull, mode);
        }
        return this.fallbackCopierOrNull.copyImmutably(source, destinationDirectory, nameOrNull, mode);
    }

    private static final File getTarget(File srcDir, File destDir, String nameOrNull, CopyModeExisting mode) throws IOExceptionUnchecked {
        String name = nameOrNull == null ? srcDir.getName() : nameOrNull;
        return new File(destDir, name);
    }
}

