/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.filesystem;

import ch.systemsx.cisd.base.exceptions.InterruptedExceptionUnchecked;
import ch.systemsx.cisd.base.utilities.OSUtilities;
import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.common.filesystem.CopyModeExisting;
import ch.systemsx.cisd.common.filesystem.IFileImmutableCopier;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.process.CallableExecutor;
import ch.systemsx.cisd.common.process.ProcessExecutionHelper;
import ch.systemsx.cisd.common.process.ProcessResult;
import ch.systemsx.cisd.common.time.TimingParameters;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.springframework.util.FileCopyUtils;

public class HardLinkMaker
implements IFileImmutableCopier {
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, HardLinkMaker.class);
    private static final Logger machineLog = LogFactory.getLogger(LogCategory.MACHINE, HardLinkMaker.class);
    private static final String HARD_LINK_EXEC = "ln";
    private final String linkExecPath;
    private final TimingParameters timingParameters;

    public static final IFileImmutableCopier tryCreate(TimingParameters timingParameters) {
        File lnExec = OSUtilities.findExecutable(HARD_LINK_EXEC);
        if (lnExec == null) {
            return null;
        }
        return HardLinkMaker.create(lnExec, timingParameters);
    }

    public static final IFileImmutableCopier tryCreate() {
        File lnExec = OSUtilities.findExecutable(HARD_LINK_EXEC);
        if (lnExec == null) {
            return null;
        }
        return HardLinkMaker.create(lnExec);
    }

    public static final IFileImmutableCopier create(File lnExec, TimingParameters timingParameters) {
        return new HardLinkMaker(lnExec.getAbsolutePath(), timingParameters);
    }

    public static final IFileImmutableCopier create(File lnExec) {
        return new HardLinkMaker(lnExec.getAbsolutePath(), TimingParameters.getDefaultParameters());
    }

    private HardLinkMaker(String linkExecPath, TimingParameters timingParameters) {
        this.linkExecPath = linkExecPath;
        this.timingParameters = timingParameters;
    }

    @Override
    public Status copyFileImmutably(File source, File destinationDirectory, String nameOrNull) {
        return this.copyFileImmutably(source, destinationDirectory, nameOrNull, CopyModeExisting.ERROR);
    }

    @Override
    public Status copyFileImmutably(File source, File destinationDirectory, String nameOrNull, CopyModeExisting mode) {
        String errorMsg;
        List<String> cmd;
        Callable<Status> processTask;
        Status ok;
        assert (source.isFile()) : String.format("Given file '%s' must be a file and is not.", source);
        File destFile = new File(destinationDirectory, nameOrNull == null ? source.getName() : nameOrNull);
        if (destFile.exists()) {
            switch (mode) {
                case OVERWRITE: {
                    destFile.delete();
                    break;
                }
                case IGNORE: {
                    return Status.OK;
                }
                default: {
                    return Status.createError("File '" + destFile + "' already exists.");
                }
            }
        }
        if ((ok = HardLinkMaker.runRepeatableProcess(processTask = new Callable<Status>(cmd = this.createLnCmdLine(source, destFile), destFile, source){
            final /* synthetic */ List val$cmd;
            final /* synthetic */ File val$destFile;
            final /* synthetic */ File val$source;
            {
                this.val$cmd = list;
                this.val$destFile = file;
                this.val$source = file2;
            }

            @Override
            public final Status call() {
                ProcessResult result = ProcessExecutionHelper.run((List<String>)this.val$cmd, operationLog, machineLog, HardLinkMaker.this.timingParameters.getTimeoutMillis());
                ProcessExecutionHelper.log(result);
                if (!result.isOK() && this.val$destFile.exists() && HardLinkMaker.checkIfIdenticalContent(this.val$source, this.val$destFile)) {
                    machineLog.warn((Object)("Link creator reported failure, but the exact copy of the file '" + this.val$source.getPath() + "' seems to exist in '" + this.val$destFile.getPath() + "'. Error will be ignored."));
                    return Status.OK;
                }
                return result.toStatus();
            }
        }, this.timingParameters.getMaxRetriesOnFailure(), this.timingParameters.getIntervalToWaitAfterFailureMillis())).isError() && (errorMsg = ok.tryGetErrorMessage()) != null && errorMsg.endsWith("Operation not supported")) {
            try {
                FileCopyUtils.copy((File)source, (File)destFile);
                return Status.OK;
            }
            catch (IOException ex) {
                return Status.createError(ex.getMessage());
            }
        }
        return ok;
    }

    private static boolean checkIfIdenticalContent(File file1, File file2) {
        InterruptedExceptionUnchecked.check();
        try {
            return FileUtils.contentEquals((File)file1, (File)file2);
        }
        catch (IOException e) {
            machineLog.warn((Object)("Error when comparing the content of a file and its link: " + e.getMessage()));
            return false;
        }
    }

    private final List<String> createLnCmdLine(File srcFile, File destFile) {
        ArrayList<String> tokens = new ArrayList<String>();
        tokens.add(this.linkExecPath);
        tokens.add(srcFile.getAbsolutePath());
        tokens.add(destFile.getAbsolutePath());
        return tokens;
    }

    private static Status runRepeatableProcess(Callable<Status> task, int maxRetryOnFailure, long millisToSleepOnFailure) {
        return new CallableExecutor(maxRetryOnFailure, millisToSleepOnFailure).executeCallable(task);
    }
}

