/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.filesystem;

import ch.systemsx.cisd.common.filesystem.FileUtilities;
import ch.systemsx.cisd.common.reflection.AbstractHashable;
import java.io.File;
import java.io.Serializable;
import java.util.regex.Pattern;

public class HostAwareFile
extends AbstractHashable
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Pattern WINDOWS_DRIVE_PATTERN = Pattern.compile("^[a-zA-Z]:[\\\\/]");
    public static final char HOST_FILE_SEP = ':';
    private final String hostOrNull;
    private final String path;
    private final String rsyncModuleOrNull;

    public HostAwareFile(File path) {
        this(null, path.getPath(), null);
    }

    public HostAwareFile(String hostOrNull, String path, String rsyncModuleOrNull) {
        this.hostOrNull = hostOrNull;
        this.path = path;
        this.rsyncModuleOrNull = rsyncModuleOrNull;
    }

    public final String tryGetHost() {
        return this.hostOrNull;
    }

    public final File getLocalFile() throws IllegalArgumentException {
        if (this.hostOrNull != null) {
            throw new IllegalArgumentException("getLocalFile can only be called on local paths.");
        }
        return new File(this.path);
    }

    public final String getPath() {
        return this.path;
    }

    public final String tryGetRsyncModule() {
        return this.rsyncModuleOrNull;
    }

    public final String getCanonicalPath() {
        return FileUtilities.getCanonicalPath(this.getLocalFile());
    }

    public final String getPathDescription() {
        if (this.tryGetHost() == null) {
            return this.getCanonicalPath();
        }
        if (this.tryGetRsyncModule() == null) {
            return this.tryGetHost() + ':' + this.getPath();
        }
        return this.tryGetHost() + ':' + this.tryGetRsyncModule() + ':' + this.getPath();
    }

    public static int getHostFileIndex(String hostFileString) {
        if (WINDOWS_DRIVE_PATTERN.matcher(hostFileString).find()) {
            return -1;
        }
        return hostFileString.indexOf(58);
    }
}

