/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.filesystem;

import ch.systemsx.cisd.common.exceptions.StatusWithResult;
import ch.systemsx.cisd.common.exceptions.UnknownLastChangedException;
import ch.systemsx.cisd.common.filesystem.AbstractCopyActivitySensor;
import ch.systemsx.cisd.common.filesystem.FileOperations;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import java.io.File;
import org.apache.log4j.Logger;

public final class RemoteDirectoryCopyActivitySensor
extends AbstractCopyActivitySensor {
    private static final Logger machineLog = LogFactory.getLogger(LogCategory.MACHINE, RemoteDirectoryCopyActivitySensor.class);
    private final File target;

    public RemoteDirectoryCopyActivitySensor(File target) {
        this.target = target;
    }

    public RemoteDirectoryCopyActivitySensor(File target, int maxErrorsToIgnore) {
        super(maxErrorsToIgnore);
        this.target = target;
    }

    @Override
    protected StatusWithResult<Long> getTargetTimeOfLastActivityMoreRecentThan(long thresholdMillis) {
        try {
            long lastChanged = FileOperations.getMonitoredInstanceForCurrentThread().lastChangedRelative(this.target, true, thresholdMillis);
            return StatusWithResult.create(lastChanged);
        }
        catch (UnknownLastChangedException ex) {
            return StatusWithResult.createRetriableErrorWithResult("Cannot determine time of last change of " + this.getTargetDescription());
        }
    }

    @Override
    protected String getTargetDescription() {
        return String.format("target '%s'", this.target);
    }

    @Override
    protected Logger getMachineLog() {
        return machineLog;
    }
}

