/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.filesystem.rsync;

import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.process.ProcessExecutionHelper;
import ch.systemsx.cisd.common.process.ProcessIOStrategy;
import ch.systemsx.cisd.common.process.ProcessResult;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;

final class RsyncVersionChecker {
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, RsyncVersionChecker.class);
    private static final Logger machineLog = LogFactory.getLogger(LogCategory.MACHINE, RsyncVersionChecker.class);

    RsyncVersionChecker() {
    }

    static RsyncVersion getVersion(String rsyncExecutable) {
        assert (rsyncExecutable != null);
        String rsyncVersionOrNull = RsyncVersionChecker.tryGetRsyncVersion(rsyncExecutable);
        if (rsyncVersionOrNull == null) {
            return null;
        }
        return RsyncVersionChecker.parseVersion(rsyncVersionOrNull);
    }

    static RsyncVersion parseVersion(String rsyncVersion) {
        int rsyncPatchVersion;
        String[] rsyncVersionParts = rsyncVersion.split("\\.");
        if (rsyncVersionParts.length != 3) {
            return null;
        }
        int rsyncMajorVersion = Integer.parseInt(rsyncVersionParts[0]);
        int rsyncMinorVersion = Integer.parseInt(rsyncVersionParts[1]);
        boolean preReleaseVersion = false;
        try {
            rsyncPatchVersion = Integer.parseInt(rsyncVersionParts[2]);
        }
        catch (NumberFormatException ex) {
            int preIdx = rsyncVersionParts[2].indexOf("pre");
            if (preIdx >= 0) {
                rsyncPatchVersion = Integer.parseInt(rsyncVersionParts[2].substring(0, preIdx));
                preReleaseVersion = true;
            }
            throw ex;
        }
        return new RsyncVersion(rsyncVersion, rsyncMajorVersion, rsyncMinorVersion, rsyncPatchVersion, preReleaseVersion);
    }

    static RsyncVersion tryParseVersionLine(String rsyncVersionLine) {
        String rsyncVersionOrNull = RsyncVersionChecker.tryExtractRsyncVersion(rsyncVersionLine);
        if (rsyncVersionOrNull == null) {
            return null;
        }
        try {
            return RsyncVersionChecker.parseVersion(rsyncVersionOrNull);
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    private static String tryGetRsyncVersion(String rsyncExecutableToCheck) {
        ProcessResult result = ProcessExecutionHelper.run(Arrays.asList(rsyncExecutableToCheck, "--version"), operationLog, machineLog, 60000L, ProcessIOStrategy.DEFAULT_IO_STRATEGY, false);
        result.log();
        List<String> processOutput = result.getOutput();
        if (processOutput.size() == 0) {
            return null;
        }
        String versionString = RsyncVersionChecker.tryExtractRsyncVersion(processOutput.get(0));
        return versionString;
    }

    private static String tryExtractRsyncVersion(String rsyncVersionLine) {
        if (!rsyncVersionLine.startsWith("rsync  version")) {
            return null;
        }
        String[] versionStringParts = rsyncVersionLine.split("\\s+");
        if (versionStringParts.length < 3) {
            return null;
        }
        return versionStringParts[2];
    }

    static class RsyncVersion {
        private final String rsyncVersion;
        private final int rsyncMajorVersion;
        private final int rsyncMinorVersion;
        private final int rsyncPatchVersion;
        private final boolean rsyncPreReleaseVersion;

        private RsyncVersion(String rsyncVersion, int rsyncMajorVersion, int rsyncMinorVersion, int rsyncPatchVersion, boolean rsyncPreReleaseVersion) {
            this.rsyncVersion = rsyncVersion;
            this.rsyncMajorVersion = rsyncMajorVersion;
            this.rsyncMinorVersion = rsyncMinorVersion;
            this.rsyncPatchVersion = rsyncPatchVersion;
            this.rsyncPreReleaseVersion = rsyncPreReleaseVersion;
        }

        public String getVersionString() {
            return this.rsyncVersion;
        }

        public int getMajorVersion() {
            return this.rsyncMajorVersion;
        }

        public int getMinorVersion() {
            return this.rsyncMinorVersion;
        }

        public int getPatchVersion() {
            return this.rsyncPatchVersion;
        }

        public boolean isRsyncPreReleaseVersion() {
            return this.rsyncPreReleaseVersion;
        }

        public boolean isNewerOrEqual(int minMajorVerson, int minMinorVersion, int minPatchLevel) {
            if (this.rsyncMajorVersion < minMajorVerson) {
                return false;
            }
            if (this.rsyncMajorVersion > minMajorVerson) {
                return true;
            }
            if (this.rsyncMinorVersion < minMinorVersion) {
                return false;
            }
            if (this.rsyncMinorVersion > minMinorVersion) {
                return true;
            }
            return this.rsyncPatchVersion >= minPatchLevel;
        }

        public String toString() {
            return this.getVersionString();
        }
    }
}

