/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.filesystem.ssh;

import ch.systemsx.cisd.common.filesystem.BooleanStatus;
import ch.systemsx.cisd.common.filesystem.ssh.ISshCommandBuilder;
import ch.systemsx.cisd.common.filesystem.ssh.ISshCommandExecutor;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.process.ProcessExecutionHelper;
import ch.systemsx.cisd.common.process.ProcessIOStrategy;
import ch.systemsx.cisd.common.process.ProcessResult;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class SshCommandExecutor
implements ISshCommandExecutor,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, SshCommandExecutor.class);
    private static final Logger machineLog = LogFactory.getLogger(LogCategory.MACHINE, SshCommandExecutor.class);
    private final ISshCommandBuilder sshCommandBuilder;
    private final String host;

    public SshCommandExecutor(File sshExecutable, String host) {
        this(SshCommandExecutor.createSshCommandBuilder(sshExecutable), host);
    }

    public SshCommandExecutor(ISshCommandBuilder sshCommandBuilder, String host) {
        this.host = host;
        this.sshCommandBuilder = sshCommandBuilder;
    }

    private String getHost() {
        assert (this.host != null) : "host cannot be null";
        return this.host;
    }

    private static String mkCheckDirectoryFullyAccessibleCommand(String path) {
        return String.format("if [ -d %1$s -a -w %1$s -a -r %1$s -a -x %1$s ]; then exit 0; else echo false; fi", path);
    }

    private static String mkCheckFileExistsCommand(String path) {
        return String.format("if [ -e %s ]; then exit 0; else echo false; fi", path);
    }

    private boolean isSuccessfulCheck(ProcessResult result) {
        return result.getOutput().size() == 0;
    }

    @Override
    public final BooleanStatus exists(String pathString, long timeOutMillis) {
        String cmd = SshCommandExecutor.mkCheckFileExistsCommand(pathString);
        ProcessResult result = this.executeCommandRemotely(cmd, timeOutMillis);
        if (result.isOK()) {
            return BooleanStatus.createFromBoolean(this.isSuccessfulCheck(result));
        }
        return BooleanStatus.createError("Remote command '" + cmd + "' failed with exit value: " + result.getExitValue());
    }

    @Override
    public BooleanStatus checkDirectoryAccessible(String pathString, long timeOutMillis) {
        String cmd = SshCommandExecutor.mkCheckDirectoryFullyAccessibleCommand(pathString);
        ProcessResult result = this.executeCommandRemotely(cmd, timeOutMillis);
        String dirDesc = "'" + this.getHost() + ":" + pathString + "'";
        if (result.isOK()) {
            if (this.isSuccessfulCheck(result)) {
                return BooleanStatus.createTrue();
            }
            String msg = "Directory not accessible: " + dirDesc + ". Check that it exists and that you have read and write permissions to it.";
            if (result.getOutput().size() > 0 && !"false".equals(result.getOutput().get(0))) {
                msg = msg + " [check says: " + StringUtils.join(result.getOutput(), (char)'\n') + "]";
            }
            return BooleanStatus.createFalse(msg);
        }
        if (result.isTimedOut()) {
            return BooleanStatus.createError("Error when checking if directory " + dirDesc + " is accessible: TIMEOUT");
        }
        return BooleanStatus.createError("Error when checking if directory " + dirDesc + " is accessible: " + result.getOutput());
    }

    @Override
    public ProcessResult executeCommandRemotely(String localCmd, long timeOutMillis) {
        return this.executeCommandRemotely(localCmd, timeOutMillis, true);
    }

    @Override
    public ProcessResult executeCommandRemotely(String localCmd, long timeOutMillis, boolean logResult) {
        List<String> cmdLine = this.sshCommandBuilder.createSshCommand(localCmd, this.getHost());
        ProcessResult result = ProcessExecutionHelper.run(cmdLine, operationLog, machineLog, timeOutMillis, ProcessIOStrategy.DEFAULT_IO_STRATEGY, false);
        if (logResult) {
            result.log();
        }
        return result;
    }

    public static ISshCommandBuilder createSshCommandBuilder(final File sshExecutable) {
        return new ISshCommandBuilder(){
            private static final long serialVersionUID = 1L;

            @Override
            public List<String> createSshCommand(String cmd, String host) {
                return SshCommandExecutor.createSshCommand(cmd, sshExecutable, host);
            }
        };
    }

    private static final List<String> createSshCommand(String command, File sshExecutable, String host) {
        ArrayList<String> wrappedCmd = new ArrayList<String>();
        List<String> sshCommand = Arrays.asList(sshExecutable.getPath(), "-T", host);
        wrappedCmd.addAll(sshCommand);
        wrappedCmd.add(command);
        return wrappedCmd;
    }
}

