/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.image;

import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;
import java.util.EnumSet;

public class IntensityRescaling {
    private static final int MAX_USHORT = 65535;

    public static boolean isNotGrayscale(BufferedImage image) {
        return image.getColorModel().getColorSpace().getNumComponents() > 1;
    }

    public static EnumSet<Channel> getUsedRgbChannels(BufferedImage image) {
        EnumSet<Channel> channels = EnumSet.noneOf(Channel.class);
        if (image.getType() != 1 && image.getType() != 2) {
            return channels;
        }
        for (int y = 0; y < image.getHeight(); ++y) {
            for (int x = 0; x < image.getWidth(); ++x) {
                int rgb = image.getRGB(x, y);
                if ((rgb >> 16 & 0xFF) > 0) {
                    channels.add(Channel.RED);
                }
                if ((rgb >> 8 & 0xFF) > 0) {
                    channels.add(Channel.GREEN);
                }
                if ((rgb & 0xFF) <= 0) continue;
                channels.add(Channel.BLUE);
            }
        }
        return channels;
    }

    public static BufferedImage rescaleIntensityBitShiftTo8Bits(Pixels image, int shiftBits) {
        BufferedImage rescaledImage = new BufferedImage(image.getWidth(), image.getHeight(), 10);
        WritableRaster raster = rescaledImage.getRaster();
        int[] pixelData = image.getPixelData()[0];
        int offset = 0;
        for (int y = 0; y < image.getHeight(); ++y) {
            for (int x = 0; x < image.getWidth(); ++x) {
                int intensity = Math.min(255, pixelData[offset++] >>> shiftBits);
                raster.setSample(x, y, 0, intensity);
            }
        }
        return rescaledImage;
    }

    public static void addToLevelStats(PixelHistogram histogram, Pixels pixels, Channel ... channels) {
        assert (channels.length > 0) : "No channels specified.";
        int[] histogramArray = histogram.getHistogram();
        int[][] pixelData = pixels.getPixelData();
        for (Channel channel : channels) {
            int band = channel.getBand();
            if (band >= pixelData.length) continue;
            int[] channelPixelData = pixelData[band];
            for (int i = 0; i < channelPixelData.length; ++i) {
                int n = channelPixelData[i];
                histogramArray[n] = histogramArray[n] + 1;
            }
            histogram.pixelCount += channelPixelData.length;
        }
    }

    public static Levels computeLevels(PixelHistogram histogram, float threshold) {
        int intThreshold = Math.round(threshold * (float)histogram.getPixelCount());
        int[] histogramArray = histogram.getHistogram();
        return IntensityRescaling.computeLevels(intThreshold, histogramArray);
    }

    public static Levels computeLevels(int intThreshold, int[] histogramArray) {
        int min = -1;
        int max = histogramArray.length;
        int minSum = 0;
        int maxSum = 0;
        while (minSum <= intThreshold || maxSum <= intThreshold) {
            if (minSum <= intThreshold) {
                minSum += histogramArray[++min];
            }
            if (min >= max - 1) break;
            if (maxSum > intThreshold) continue;
            maxSum += histogramArray[--max];
        }
        if (max >= histogramArray.length) {
            max = histogramArray.length - 1;
        }
        return new Levels(min, max);
    }

    public static Levels computeLevels(Pixels pixels, int minimumNumberOfLevels) {
        Levels levels = null;
        float threshold = 0.01f;
        while ((double)threshold > 1.0E-5 && (levels = IntensityRescaling.computeLevels(pixels, threshold, Channel.values())).getMaxLevel() - levels.getMinLevel() <= minimumNumberOfLevels) {
            threshold /= 10.0f;
        }
        return levels;
    }

    public static Levels computeLevels(Pixels image, float threshold, Channel ... channels) {
        assert (channels.length > 0) : "No channels specified.";
        PixelHistogram stats = new PixelHistogram();
        IntensityRescaling.addToLevelStats(stats, image, channels);
        return IntensityRescaling.computeLevels(stats, threshold);
    }

    public static BufferedImage rescaleIntensityLevelTo8Bits(Pixels pixels, Levels levels, Channel ... channels) {
        assert (channels.length > 0) : "No channels specified.";
        int width = pixels.getWidth();
        int height = pixels.getHeight();
        int[][] pixelData = pixels.getPixelData();
        int numberOfColorComponents = pixelData.length;
        int type = numberOfColorComponents == 1 ? 10 : 1;
        BufferedImage rescaledImage = new BufferedImage(width, height, type);
        WritableRaster rescaledRaster = rescaledImage.getRaster();
        for (int y = 0; y < height; ++y) {
            int offset = y * width;
            for (int x = 0; x < width; ++x) {
                int intensity = 0;
                for (Channel channel : channels) {
                    int band = channel.getBand();
                    if (band >= numberOfColorComponents) continue;
                    intensity = Math.max(intensity, pixelData[band][offset + x]);
                }
                if (intensity == 0) continue;
                int rescaledIntensity = IntensityRescaling.rescaleIntensity(intensity, levels);
                for (Channel channel : channels) {
                    int band = channel.getBand();
                    if (band >= numberOfColorComponents) continue;
                    int bandIntensity = pixelData[band][offset + x];
                    int rescaledBandIntensity = (bandIntensity * rescaledIntensity + intensity / 2) / intensity;
                    rescaledRaster.setSample(x, y, band, rescaledBandIntensity);
                }
            }
        }
        return rescaledImage;
    }

    private static int rescaleIntensity(int originalIntensity, Levels levels) {
        int intensity = Math.min(levels.maxLevel, originalIntensity);
        intensity = Math.max(0, intensity - levels.minLevel);
        int range = levels.maxLevel - levels.minLevel;
        return (255 * intensity + range / 2) / range;
    }

    public static interface IImageToPixelsConverter {
        public Pixels convert(BufferedImage var1);
    }

    public static class Pixels {
        private final int width;
        private final int height;
        private final int[][] pixelData;

        public Pixels(BufferedImage image) {
            block8: {
                block7: {
                    this.width = image.getWidth();
                    this.height = image.getHeight();
                    ColorModel colorModel = image.getColorModel();
                    int numColorComponents = colorModel.getNumColorComponents();
                    this.pixelData = new int[numColorComponents][this.width * this.height];
                    WritableRaster raster = image.getRaster();
                    int numberOfBands = raster.getNumBands();
                    int[][] colorIndexMap = null;
                    if (numColorComponents == 3 && numberOfBands == 1) {
                        colorIndexMap = this.tryCreateColorIndexMap(colorModel);
                    }
                    if (numberOfBands < this.pixelData.length && colorIndexMap == null) break block7;
                    int n = Math.min(numberOfBands, this.pixelData.length);
                    for (int band = 0; band < n; ++band) {
                        raster.getSamples(0, 0, this.width, this.height, band, this.pixelData[band]);
                    }
                    if (colorIndexMap == null) break block8;
                    for (int i = 0; i < this.pixelData[0].length; ++i) {
                        int index = this.pixelData[0][i];
                        for (int c = 0; c < 3; ++c) {
                            this.pixelData[c][i] = colorIndexMap[c][index];
                        }
                    }
                    break block8;
                }
                for (int y = 0; y < this.height; ++y) {
                    int offset = y * this.width;
                    for (int x = 0; x < this.width; ++x) {
                        int rgb = image.getRGB(x, y);
                        for (Channel channel : Channel.values()) {
                            this.pixelData[channel.getBand()][offset + x] = rgb >> channel.getShift() & 0xFF;
                        }
                    }
                }
            }
        }

        protected int[][] tryCreateColorIndexMap(ColorModel colorModel) {
            if (!(colorModel instanceof IndexColorModel)) {
                return null;
            }
            IndexColorModel indexColorModel = (IndexColorModel)colorModel;
            int mapSize = indexColorModel.getMapSize();
            byte[] blues = new byte[mapSize];
            indexColorModel.getBlues(blues);
            byte[] greens = new byte[mapSize];
            indexColorModel.getGreens(greens);
            byte[] reds = new byte[mapSize];
            indexColorModel.getReds(reds);
            int[][] result = new int[3][mapSize];
            this.copyTo(reds, result[0]);
            this.copyTo(greens, result[1]);
            this.copyTo(blues, result[2]);
            return result;
        }

        private void copyTo(byte[] bytes, int[] integers) {
            for (int i = 0; i < bytes.length; ++i) {
                integers[i] = bytes[i] & 0xFF;
            }
        }

        public int[][] getPixelData() {
            return this.pixelData;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }
    }

    public static class PixelHistogram {
        final int[] histogram = new int[65536];
        int pixelCount = 0;

        public int getPixelCount() {
            return this.pixelCount;
        }

        public int[] getHistogram() {
            return this.histogram;
        }
    }

    public static class Levels {
        final int minLevel;
        final int maxLevel;

        public Levels(int minLevel, int maxLevel) {
            this.minLevel = minLevel;
            this.maxLevel = maxLevel;
        }

        public int getMinLevel() {
            return this.minLevel;
        }

        public int getMaxLevel() {
            return this.maxLevel;
        }

        public String toString() {
            return "MinMax [minLevel=" + this.minLevel + ", maxLevel=" + this.maxLevel + "]";
        }
    }

    public static enum Channel {
        RED(0, 16),
        GREEN(1, 8),
        BLUE(2, 0);

        private int band;
        private int shift;

        private Channel(int band, int shift) {
            this.band = band;
            this.shift = shift;
        }

        public int getShift() {
            return this.shift;
        }

        public int getBand() {
            return this.band;
        }
    }
}

