/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.io;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ConcatenatedFileOutputStreamWriter {
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    private static final int BYTES_PER_LONG = 8;
    private final InputStream inputStream;
    private final byte[] blockSizeBuffer = new byte[8];
    private final byte[] fileChunkBuffer = new byte[8192];
    private long bytesToReadFromCurrent;

    public ConcatenatedFileOutputStreamWriter(InputStream inputStream) {
        this.inputStream = inputStream;
        this.bytesToReadFromCurrent = 0L;
    }

    public long writeNextBlock(OutputStream output) throws IOException {
        long blockSize = this.beginReadingNextBlock();
        if (blockSize == -1L) {
            return -1L;
        }
        return this.copyCurrentBlock(output);
    }

    private long copyCurrentBlock(OutputStream output) throws IOException {
        long count = 0L;
        int n = 0;
        while (-1 != (n = this.readCurrent(this.fileChunkBuffer, 0, this.fileChunkBuffer.length))) {
            output.write(this.fileChunkBuffer, 0, n);
            count += (long)n;
        }
        return count;
    }

    private long beginReadingNextBlock() throws IOException {
        if (this.bytesToReadFromCurrent > 0L) {
            throw new IllegalStateException("Cannot proceed to the next file before the current one is not read till the end.");
        }
        this.bytesToReadFromCurrent = this.readBlockSize();
        return this.bytesToReadFromCurrent;
    }

    private long readBlockSize() throws IOException {
        if (!this.readExactly(this.blockSizeBuffer, 8)) {
            return -1L;
        }
        long blockSize = ConcatenatedFileOutputStreamWriter.bytesToLong(this.blockSizeBuffer);
        assert (blockSize >= 0L) : "block size cannot be negative";
        return blockSize;
    }

    private boolean readExactly(byte[] data, int wantedBytes) throws IOException {
        int bytesRead;
        int chunkBytesRead;
        for (bytesRead = 0; bytesRead < 8; bytesRead += chunkBytesRead) {
            chunkBytesRead = this.inputStream.read(this.blockSizeBuffer, bytesRead, wantedBytes - bytesRead);
            if (chunkBytesRead != -1) continue;
            if (bytesRead == 0) {
                return false;
            }
            throw new IOException("Stream corrupted, " + wantedBytes + " bytes expected but only " + bytesRead + " available.");
        }
        assert (bytesRead == wantedBytes) : "not enough bytes read";
        return true;
    }

    private int readCurrent(byte[] b, int off, int len) throws IOException {
        if (len == 0) {
            return 0;
        }
        if (this.bytesToReadFromCurrent == 0L) {
            return -1;
        }
        int wantedBytes = (int)Math.min((long)len, this.bytesToReadFromCurrent);
        int bytesRead = this.inputStream.read(b, off, wantedBytes);
        if (bytesRead == -1) {
            throw new IOException("Corrupted stream, there should be at least " + wantedBytes + " bytes in the block, but the end of the stream has been reached.");
        }
        this.bytesToReadFromCurrent -= (long)bytesRead;
        return bytesRead;
    }

    private static long bytesToLong(byte[] bytes) throws IOException {
        ByteArrayInputStream bos = new ByteArrayInputStream(bytes);
        DataInputStream dos = new DataInputStream(bos);
        try {
            long l = dos.readLong();
            return l;
        }
        catch (IOException e) {
            throw new IOException("Cannot create the long from bytes: " + bytes);
        }
        finally {
            try {
                dos.close();
            }
            catch (IOException iOException) {}
        }
    }
}

