/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.jython;

import ch.systemsx.cisd.common.filesystem.FileUtilities;
import ch.systemsx.cisd.common.jython.evaluator.EvaluatorException;
import ch.systemsx.cisd.common.shared.basic.string.StringUtils;
import java.io.File;
import java.util.ArrayList;

public class JythonUtils {
    public static String extractScriptFromPath(String scriptPath) throws EvaluatorException {
        File scriptFile = new File(scriptPath);
        if (!scriptFile.exists()) {
            throw new EvaluatorException("Plugin script [" + scriptPath + "] specified in the configuration doesn't exist.");
        }
        String scriptString = FileUtilities.loadToString(scriptFile);
        if (StringUtils.isBlank(scriptString)) {
            throw new EvaluatorException("Plugin script [" + scriptPath + "] specified in the configuration is empty.");
        }
        try {
            return scriptString + "\n";
        }
        catch (EvaluatorException ex) {
            throw new EvaluatorException(ex.getMessage() + " [" + scriptPath + "]");
        }
    }

    public static String[] getScriptDirectoryPythonPath(String ... scriptPaths) {
        if (scriptPaths == null || scriptPaths.length == 0) {
            return null;
        }
        ArrayList<String> pythonPath = new ArrayList<String>();
        for (String scriptPath : scriptPaths) {
            File scriptFile;
            File scriptDirectory;
            if (scriptPath == null || (scriptDirectory = (scriptFile = new File(scriptPath)).getParentFile()) == null) continue;
            pythonPath.add(scriptDirectory.getAbsolutePath());
        }
        if (pythonPath.isEmpty()) {
            return null;
        }
        return pythonPath.toArray(new String[pythonPath.size()]);
    }
}

