/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.jython.v27;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.common.jython.v27.PythonInterpreter27;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import org.python27.core.Py;
import org.python27.core.PyDictionary;
import org.python27.core.PyFunction;
import org.python27.core.PyObject;
import org.python27.core.PySequenceList;

class JythonUtils {
    JythonUtils() {
    }

    static Map<String, String> convertPyDictToMap(PyDictionary result) {
        HashMap<String, String> javaMap = new HashMap<String, String>();
        for (Object item : result.items()) {
            PySequenceList tuple = (PySequenceList)item;
            javaMap.put(tuple.get(0).toString(), tuple.get(1).toString());
        }
        return javaMap;
    }

    static PyFunction tryJythonFunction(PythonInterpreter27 interpreter, String functionName) {
        try {
            PyFunction function = (PyFunction)interpreter.get(functionName, PyFunction.class);
            return function;
        }
        catch (Exception e) {
            return null;
        }
    }

    static PyObject invokeFunction(PyFunction function, Object ... args) {
        PyObject[] pyArgs = new PyObject[args.length];
        for (int i = 0; i < args.length; ++i) {
            pyArgs[i] = Py.java2py((Object)args[i]);
        }
        return JythonUtils.invokeFunction(function, pyArgs);
    }

    static PyObject invokeFunction(final PyFunction function, final PyObject[] pyArgs) {
        return JythonUtils.executeWithContextClassLoader(function, new Callable<PyObject>(){

            @Override
            public PyObject call() throws Exception {
                return function.__call__(pyArgs);
            }
        });
    }

    static final <V> V executeWithContextClassLoader(Object object, Callable<V> action) {
        Thread thread = Thread.currentThread();
        ClassLoader originalContextClassLoader = thread.getContextClassLoader();
        try {
            V v;
            thread.setContextClassLoader(object.getClass().getClassLoader());
            try {
                v = action.call();
            }
            catch (Exception ex) {
                throw CheckedExceptionTunnel.wrapIfNecessary(ex);
            }
            return v;
        }
        finally {
            thread.setContextClassLoader(originalContextClassLoader);
        }
    }
}

