/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.jython.v27;

import ch.systemsx.cisd.common.jython.JythonUtils;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.resource.Resources;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;
import org.python27.core.CompileMode;
import org.python27.core.CompilerFlags;
import org.python27.core.Py;
import org.python27.core.PyList;
import org.python27.core.PyObject;
import org.python27.core.PyString;
import org.python27.core.PySystemState;
import org.python27.util.PythonInterpreter;

class PythonInterpreter27
extends PythonInterpreter {
    private Logger log = LogFactory.getLogger(LogCategory.OPERATION, ((Object)((Object)this)).getClass());
    private Resources resources = new Resources();

    protected PythonInterpreter27() {
    }

    private PythonInterpreter27(PyObject dict, PySystemState systemState) {
        super(dict, systemState);
    }

    public void set(String name, Object value) {
        super.set(name, value);
        this.resources.add(value);
    }

    public void set(String name, PyObject value) {
        super.set(name, value);
        this.resources.add(value);
    }

    public void addToPath(String ... pathElements) {
        if (pathElements != null) {
            PyList pyPath = this.getSystemState().path;
            for (String pathElement : pathElements) {
                PyString pyPathElement = new PyString(pathElement);
                if (pyPath.contains((Object)pyPathElement)) continue;
                pyPath.add((Object)pyPathElement);
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Python path: " + this.getSystemState().path));
        }
    }

    public void removeFromPath(String ... pathElements) {
        if (pathElements != null) {
            PyList pyPath = this.getSystemState().path;
            for (String pathElement : pathElements) {
                PyString pyPathElement = new PyString(pathElement);
                if (!pyPath.contains((Object)pyPathElement)) continue;
                pyPath.remove((PyObject)new PyString(pathElement));
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Python path: " + this.getSystemState().path));
        }
    }

    public void releaseResources() {
        this.resources.release();
    }

    public static PythonInterpreter27 createIsolatedPythonInterpreter() {
        return new PythonInterpreter27(null, new PySystemState());
    }

    public static PythonInterpreter27 createNonIsolatedPythonInterpreter() {
        return new PythonInterpreter27();
    }

    public void exec(final String s) {
        ch.systemsx.cisd.common.jython.v27.JythonUtils.executeWithContextClassLoader((Object)this, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                PythonInterpreter27.super.exec(s);
                return null;
            }
        });
    }

    public void exec(final PyObject code) {
        ch.systemsx.cisd.common.jython.v27.JythonUtils.executeWithContextClassLoader((Object)this, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                PythonInterpreter27.super.exec(code);
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exec(final String data, final String filename) {
        String[] pythonPath = JythonUtils.getScriptDirectoryPythonPath(filename);
        try {
            this.addToPath(pythonPath);
            this.setSystemState();
            ch.systemsx.cisd.common.jython.v27.JythonUtils.executeWithContextClassLoader((Object)this, new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    Py.exec((PyObject)Py.compile_flags((String)data, (String)filename, (CompileMode)CompileMode.exec, (CompilerFlags)PythonInterpreter27.this.cflags), (PyObject)PythonInterpreter27.this.getLocals(), null);
                    return null;
                }
            });
            Py.flushLine();
        }
        finally {
            this.removeFromPath(pythonPath);
        }
    }
}

