/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.logging;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.xml.DOMConfigurator;

public class LogInitializer {
    private static final String LOG_DIRECTORY = "etc";
    private static final String LOG_FILENAME = "log.xml";
    private static final String FILE_URL_PREFIX = "file:";
    private static boolean initialized;

    private static final URL createURL(String configurationOrNull) {
        try {
            if (configurationOrNull != null) {
                return new URL(configurationOrNull);
            }
        }
        catch (MalformedURLException ex) {
            ex.printStackTrace();
        }
        URL resource = LogInitializer.class.getResource("/etc/log.xml");
        return resource;
    }

    private static final String tryFindConfigurationInSystemProperties() {
        String trimmed;
        String configuration = System.getProperty("log4j.configuration");
        if (configuration != null && (trimmed = configuration.trim()).length() > 0) {
            return trimmed;
        }
        return null;
    }

    private static final File createLogFile(String configurationOrNull) {
        if (configurationOrNull == null) {
            return new File(LOG_DIRECTORY, LOG_FILENAME);
        }
        return new File(configurationOrNull);
    }

    private static final void configureFromFile(File logFile) {
        assert (logFile != null && logFile.exists()) : "Given log file must be not null and must exist.";
        DOMConfigurator.configureAndWatch((String)logFile.getPath());
        LogLog.debug((String)String.format("Log configured from file '%s' (watching).", logFile.getAbsolutePath()));
    }

    private static final void configureFromURL(URL url) {
        assert (url != null) : "Given url can not be null.";
        try {
            File logFile = new File(url.toURI());
            if (logFile.exists()) {
                LogInitializer.configureFromFile(logFile);
                return;
            }
        }
        catch (URISyntaxException ex) {
            LogLog.warn((String)String.format("Given url '%s' could not be parsed.", url), (Throwable)ex);
        }
        DOMConfigurator.configure((URL)url);
        LogLog.debug((String)String.format("Log configured from URL '%s' (NOT watching).", url));
    }

    private static final void finishInit() {
        initialized = true;
        LogLog.setQuietMode((boolean)true);
    }

    public static final synchronized void init() {
        URL url;
        File logFile;
        if (initialized) {
            return;
        }
        String configuration = LogInitializer.tryFindConfigurationInSystemProperties();
        if ((configuration == null || !configuration.startsWith(FILE_URL_PREFIX)) && (logFile = LogInitializer.createLogFile(configuration)).exists()) {
            LogInitializer.configureFromFile(logFile);
            LogInitializer.finishInit();
            return;
        }
        if ((configuration == null || configuration.startsWith(FILE_URL_PREFIX)) && (url = LogInitializer.createURL(configuration)) != null) {
            LogInitializer.configureFromURL(url);
            LogInitializer.finishInit();
            return;
        }
        BasicConfigurator.configure();
        LogInitializer.finishInit();
    }

    static {
        System.setProperty("log4j.defaultInitOverride", "true");
        initialized = false;
    }
}

