/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.mail;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.filesystem.FileUtilities;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.mail.EMailAddress;
import ch.systemsx.cisd.common.mail.From;
import ch.systemsx.cisd.common.mail.IMailClient;
import ch.systemsx.cisd.common.mail.MailClientParameters;
import ch.systemsx.cisd.common.properties.ExtendedProperties;
import ch.systemsx.cisd.common.shared.basic.string.StringUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.SendFailedException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.apache.log4j.Logger;

public final class MailClient
extends Authenticator
implements IMailClient {
    private static final String FILE_PREFIX = "file://";
    public static final String MAIL_SMTP_PASSWORD = "mail.smtp.password";
    public static final String MAIL_TEST_ADDRESS = "mail.test.address";
    private static final String UNICODE_CHARSET = "utf-8";
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, MailClient.class);
    private final Properties properties;

    public MailClient(String from, String smtpHost) {
        this(from, smtpHost, null, null, null, null);
    }

    public MailClient(String from, String smtpHost, String smtpPort, String smtpUsername, String smtpPassword, String testAddress) {
        assert (from != null);
        assert (smtpHost != null);
        this.properties = new Properties();
        this.properties.put("mail.from", from);
        this.properties.put("mail.smtp.host", smtpHost);
        if (smtpPort != null) {
            this.properties.put("mail.smtp.port", smtpPort);
        }
        if (smtpUsername != null) {
            this.properties.put("mail.smtp.user", smtpUsername);
        }
        if (smtpPassword != null) {
            this.properties.put(MAIL_SMTP_PASSWORD, smtpPassword);
        }
        if (testAddress != null) {
            this.properties.put(MAIL_TEST_ADDRESS, testAddress);
        }
        this.init();
    }

    public MailClient(MailClientParameters parameters) {
        this(parameters.getPropertiesInstance());
    }

    public MailClient(Properties properties) {
        this.properties = ExtendedProperties.createWith(properties);
        this.init();
    }

    private void init() {
        String smtpUsername = this.properties.getProperty("mail.smtp.user");
        String smtpPassword = this.properties.getProperty(MAIL_SMTP_PASSWORD);
        if (StringUtils.isNotBlank(smtpUsername) && StringUtils.isNotBlank(smtpPassword)) {
            this.properties.put("mail.smtp.auth", Boolean.TRUE.toString());
        }
        this.properties.put("mail.debug", operationLog.isDebugEnabled() ? Boolean.TRUE.toString() : Boolean.FALSE.toString());
        this.properties.put("mail.transport.protocol", "smtp");
        try {
            Properties systemProperties = System.getProperties();
            for (String key : systemProperties.stringPropertyNames()) {
                if (this.properties.containsKey(key)) continue;
                this.properties.put(key, systemProperties.getProperty(key));
            }
        }
        catch (SecurityException ex) {
            operationLog.error((Object)"System properties can't be read", (Throwable)ex);
        }
        for (String key : this.properties.stringPropertyNames()) {
            if (key.startsWith("mail.")) continue;
            this.properties.remove(key);
        }
    }

    @Override
    public void sendTestEmail() {
        String testAddress = this.properties.getProperty(MAIL_TEST_ADDRESS);
        if (testAddress != null) {
            if (operationLog.isInfoEnabled()) {
                operationLog.info((Object)"Sending test email.");
            }
            this.sendEmailMessage("test", "", null, null, new EMailAddress(testAddress));
        } else if (operationLog.isInfoEnabled()) {
            operationLog.info((Object)"Test address was not provided.");
        }
    }

    private final Session createSession() {
        boolean mailSmtpAuth;
        if (operationLog.isDebugEnabled()) {
            operationLog.debug((Object)("Creating mail session with following properties '" + this.properties + "'."));
        }
        Session session = Session.getInstance((Properties)this.properties, (Authenticator)((mailSmtpAuth = Boolean.parseBoolean(this.properties.getProperty("mail.smtp.auth"))) ? this : null));
        session.setDebug(operationLog.isDebugEnabled());
        return session;
    }

    private static final InternetAddress createInternetAddress(From internetAddressOrNull) {
        if (internetAddressOrNull == null) {
            return null;
        }
        return MailClient.createInternetAddress(internetAddressOrNull.getValue());
    }

    private static final InternetAddress createInternetAddress(String internetAddressOrNull) {
        if (internetAddressOrNull == null) {
            return null;
        }
        try {
            return new InternetAddress(internetAddressOrNull);
        }
        catch (AddressException e) {
            operationLog.error((Object)("Could not parse address [" + internetAddressOrNull + "]."), (Throwable)e);
            throw CheckedExceptionTunnel.wrapIfNecessary((Exception)((Object)e));
        }
    }

    private static final InternetAddress[] createInternetAddresses(EMailAddress[] addressesOrNull) {
        if (addressesOrNull == null) {
            return null;
        }
        InternetAddress[] addresses = new InternetAddress[addressesOrNull.length];
        for (int i = 0; i < addresses.length; ++i) {
            addresses[i] = MailClient.createInternetAddress(addressesOrNull[i]);
        }
        return addresses;
    }

    private static final InternetAddress[] createInternetAddresses(String[] addressesOrNull) {
        if (addressesOrNull == null) {
            return null;
        }
        InternetAddress[] addresses = new InternetAddress[addressesOrNull.length];
        for (int i = 0; i < addresses.length; ++i) {
            addresses[i] = MailClient.createInternetAddress(addressesOrNull[i]);
        }
        return addresses;
    }

    private static final InternetAddress createInternetAddress(EMailAddress addressOrNull) {
        if (addressOrNull == null || addressOrNull.tryGetEmailAddress() == null) {
            return null;
        }
        try {
            return new InternetAddress(addressOrNull.tryGetEmailAddress(), addressOrNull.tryGetPersonalName());
        }
        catch (Exception e) {
            operationLog.error((Object)("Could not parse address [" + addressOrNull + "]."), (Throwable)e);
            throw CheckedExceptionTunnel.wrapIfNecessary(e);
        }
    }

    @Override
    public final void sendMessage(String subject, final String content, String replyToOrNull, From fromOrNull, String ... recipients) throws EnvironmentFailureException {
        IMessagePreparer messagePreparer = new IMessagePreparer(){

            @Override
            public void prepareMessage(MimeMessage msg) throws MessagingException {
                msg.setText(content);
            }
        };
        this.privateSendMessage(messagePreparer, subject, MailClient.createInternetAddress(replyToOrNull), MailClient.createInternetAddress(fromOrNull), MailClient.createInternetAddresses(recipients));
    }

    @Override
    public void sendEmailMessage(String subject, final String content, EMailAddress replyToOrNull, EMailAddress fromOrNull, EMailAddress ... recipients) throws EnvironmentFailureException {
        IMessagePreparer messagePreparer = new IMessagePreparer(){

            @Override
            public void prepareMessage(MimeMessage msg) throws MessagingException {
                msg.setText(content);
            }
        };
        this.privateSendMessage(messagePreparer, subject, MailClient.createInternetAddress(replyToOrNull), MailClient.createInternetAddress(fromOrNull), MailClient.createInternetAddresses(recipients));
    }

    @Override
    public final void sendMessageWithAttachment(String subject, final String content, final String filename, final DataHandler attachmentContent, String replyTo, From fromOrNull, String ... recipients) throws EnvironmentFailureException {
        IMessagePreparer messagePreparer = new IMessagePreparer(){

            @Override
            public void prepareMessage(MimeMessage msg) throws MessagingException {
                MimeMultipart multipart = new MimeMultipart();
                MimeBodyPart messageText = new MimeBodyPart();
                messageText.setText(content);
                multipart.addBodyPart((BodyPart)messageText);
                MimeBodyPart messageAttachment = new MimeBodyPart();
                messageAttachment.setDataHandler(attachmentContent);
                messageAttachment.setFileName(filename);
                multipart.addBodyPart((BodyPart)messageAttachment);
                msg.setContent((Multipart)multipart);
            }
        };
        this.privateSendMessage(messagePreparer, subject, MailClient.createInternetAddress(replyTo), MailClient.createInternetAddress(fromOrNull), MailClient.createInternetAddresses(recipients));
    }

    @Override
    public void sendEmailMessageWithAttachment(String subject, final String content, final String filename, final DataHandler attachmentContent, EMailAddress replyToOrNull, EMailAddress fromOrNull, EMailAddress ... recipients) throws EnvironmentFailureException {
        IMessagePreparer messagePreparer = new IMessagePreparer(){

            @Override
            public void prepareMessage(MimeMessage msg) throws MessagingException {
                MimeMultipart multipart = new MimeMultipart();
                MimeBodyPart messageText = new MimeBodyPart();
                messageText.setText(content);
                multipart.addBodyPart((BodyPart)messageText);
                MimeBodyPart messageAttachment = new MimeBodyPart();
                messageAttachment.setDataHandler(attachmentContent);
                messageAttachment.setFileName(filename);
                multipart.addBodyPart((BodyPart)messageAttachment);
                msg.setContent((Multipart)multipart);
            }
        };
        this.privateSendMessage(messagePreparer, subject, MailClient.createInternetAddress(replyToOrNull), MailClient.createInternetAddress(fromOrNull), MailClient.createInternetAddresses(recipients));
    }

    private final void privateSendMessage(IMessagePreparer messagePreparerOrNull, String subject, InternetAddress replyTo, InternetAddress fromOrNull, InternetAddress[] recipients) throws EnvironmentFailureException {
        InternetAddress fromPerMail;
        String from = this.properties.getProperty("mail.from");
        InternetAddress internetAddress = fromPerMail = fromOrNull != null ? fromOrNull : MailClient.createInternetAddress(from);
        if (operationLog.isInfoEnabled()) {
            operationLog.info((Object)("Sending message from '" + fromPerMail + "' to recipients '" + Arrays.asList(recipients) + "'"));
        }
        MimeMessage msg = new MimeMessage(this.createSession());
        try {
            msg.setFrom((Address)fromPerMail);
            if (replyTo != null) {
                InternetAddress[] replyToAddress = new InternetAddress[]{replyTo};
                msg.setReplyTo((Address[])replyToAddress);
            }
            msg.addRecipients(Message.RecipientType.TO, (Address[])recipients);
            msg.setSubject(subject, UNICODE_CHARSET);
            if (null != messagePreparerOrNull) {
                messagePreparerOrNull.prepareMessage(msg);
            }
            msg.setSentDate(new Date());
            this.send(msg);
        }
        catch (MessagingException ex) {
            Address[] invalidAddressesOrNull;
            StringBuilder b = new StringBuilder();
            b.append("Sending e-mail with subject '");
            b.append(subject);
            b.append("' to recipients ");
            b.append(Arrays.asList(recipients));
            b.append(" failed.");
            if (ex instanceof SendFailedException && (invalidAddressesOrNull = ((SendFailedException)ex).getInvalidAddresses()) != null && invalidAddressesOrNull.length > 0) {
                b.append(" These email addresses are invalid:\n");
                for (Address address : invalidAddressesOrNull) {
                    b.append(address.toString());
                    b.append('\n');
                }
            }
            b.append("\nDetailed failure description:\n");
            b.append(ex.toString());
            throw new EnvironmentFailureException(b.toString(), ex);
        }
    }

    private void send(MimeMessage msg) throws MessagingException {
        String smtpHost = this.properties.getProperty("mail.smtp.host");
        if (smtpHost.startsWith(FILE_PREFIX)) {
            this.writeMessageToFile(msg);
        } else {
            Transport.send((Message)msg);
        }
    }

    private void writeMessageToFile(MimeMessage msg) throws MessagingException {
        String smtpHost = this.properties.getProperty("mail.smtp.host");
        File emailFolder = new File(smtpHost.substring(FILE_PREFIX.length()));
        if (emailFolder.exists()) {
            if (!emailFolder.isDirectory()) {
                throw new EnvironmentFailureException("There exists already a file but not a folder with path '" + emailFolder.getAbsolutePath() + "'.");
            }
        } else if (!emailFolder.mkdirs()) {
            throw new EnvironmentFailureException("Couldn't create email folder '" + emailFolder.getAbsolutePath() + "'.");
        }
        File file = FileUtilities.createTimestampUniqueFile(new File(emailFolder, "email"), null);
        StringBuilder builder = new StringBuilder();
        Enumeration headers = msg.getAllHeaderLines();
        while (headers.hasMoreElements()) {
            builder.append((String)headers.nextElement()).append('\n');
        }
        builder.append("Content:\n");
        try {
            Object content = msg.getContent();
            if (content instanceof Multipart) {
                Multipart multipart = (Multipart)content;
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                multipart.writeTo((OutputStream)os);
                builder.append(os.toString());
            } else {
                builder.append(content);
            }
        }
        catch (IOException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary(ex);
        }
        FileUtilities.writeToFile(file, builder.toString());
    }

    protected final PasswordAuthentication getPasswordAuthentication() {
        String smtpUsername = this.properties.getProperty("mail.smtp.user");
        String smtpPassword = this.properties.getProperty(MAIL_SMTP_PASSWORD);
        return new PasswordAuthentication(smtpUsername, smtpPassword);
    }

    private static interface IMessagePreparer {
        public void prepareMessage(MimeMessage var1) throws MessagingException;
    }
}

