/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.maintenance;

import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.maintenance.INextTimestampProvider;
import ch.systemsx.cisd.common.properties.PropertyUtils;
import ch.systemsx.cisd.common.time.DateTimeUtils;
import java.io.File;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.springframework.scheduling.support.CronSequenceGenerator;

public class MaintenanceTaskParameters {
    public static final String RUN_SCHEDULE_KEY = "run-schedule";
    public static final String RUN_SCHEDULE_FILE_KEY = "run-schedule-file";
    public static final String RETRY_INTERVALS_AFTER_FAILURE_KEY = "retry-intervals-after-failure";
    public static final String CLASS_KEY = "class";
    public static final String INTERVAL_KEY = "interval";
    static final String CRON_PREFIX = "cron:";
    static final String TIME_FORMAT = "HH:mm";
    static final int ONE_DAY_IN_SEC = 86400;
    static final String START_KEY = "start";
    public static final String ONE_TIME_EXECUTION_KEY = "execute-only-once";
    private final String pluginName;
    private final long interval;
    private final String className;
    private final Properties properties;
    private final Date startDate;
    private final boolean executeOnlyOnce;
    private final List<Long> retryIntervals;
    private INextTimestampProvider nextTimestampProvider;
    private File persistentNextDateFile;

    public MaintenanceTaskParameters(Properties properties, String pluginName) {
        this.properties = properties;
        this.pluginName = pluginName;
        this.interval = DateTimeUtils.getDurationInMillis(properties, INTERVAL_KEY, 86400000L) / 1000L;
        this.className = PropertyUtils.getMandatoryProperty(properties, CLASS_KEY);
        this.startDate = MaintenanceTaskParameters.extractStartDate(PropertyUtils.getProperty(properties, START_KEY));
        this.executeOnlyOnce = PropertyUtils.getBoolean(properties, ONE_TIME_EXECUTION_KEY, false);
        List<Long> intervals = MaintenanceTaskParameters.getRetryIntervals(properties);
        this.retryIntervals = intervals;
        String runScheduleDescription = properties.getProperty(RUN_SCHEDULE_KEY, null);
        if (runScheduleDescription != null) {
            this.nextTimestampProvider = MaintenanceTaskParameters.createNextTimestampProvider(runScheduleDescription);
            String defaultPath = MaintenanceTaskParameters.getPersistenNextDateFile(pluginName, this.className).getAbsolutePath();
            this.persistentNextDateFile = new File(properties.getProperty(RUN_SCHEDULE_FILE_KEY, defaultPath));
        }
    }

    private static Date extractStartDate(String timeOrNull) {
        try {
            if (StringUtils.isBlank((CharSequence)timeOrNull)) {
                return Calendar.getInstance().getTime();
            }
            SimpleDateFormat format = new SimpleDateFormat(TIME_FORMAT);
            Date parsedDate = format.parse(timeOrNull);
            Calendar rightHourAndMinutes1970 = Calendar.getInstance();
            rightHourAndMinutes1970.setTime(parsedDate);
            Calendar result = Calendar.getInstance();
            result.set(11, rightHourAndMinutes1970.get(11));
            result.set(12, rightHourAndMinutes1970.get(12));
            Calendar now = Calendar.getInstance();
            if (now.after(result)) {
                result.add(5, 1);
            }
            return result.getTime();
        }
        catch (ParseException ex) {
            throw new ConfigurationFailureException(String.format("Start date <%s> does not match the required format <%s>", timeOrNull, TIME_FORMAT));
        }
    }

    private static List<Long> getRetryIntervals(Properties properties) {
        String retryIntervals = properties.getProperty(RETRY_INTERVALS_AFTER_FAILURE_KEY);
        ArrayList<Long> intervals = new ArrayList<Long>();
        if (StringUtils.isNotBlank((CharSequence)retryIntervals)) {
            for (String retryInterval : retryIntervals.split(",")) {
                intervals.add(DateTimeUtils.parseDurationToMillis(retryInterval));
            }
        }
        return intervals;
    }

    private static File getPersistenNextDateFile(String pluginName, String className) {
        return new File(MaintenanceTaskParameters.findFolderForPersistentNextDateFile(), pluginName + "_" + className);
    }

    private static File findFolderForPersistentNextDateFile() {
        File etc;
        for (File file = etc = new File(System.getProperty("user.dir"), "etc"); file != null; file = file.getParentFile()) {
            if (!file.getName().equals("servers")) continue;
            return file.getParentFile();
        }
        return etc;
    }

    public boolean isExecuteOnlyOnce() {
        return this.executeOnlyOnce;
    }

    public long getIntervalSeconds() {
        return this.interval;
    }

    public String getClassName() {
        return this.className;
    }

    public String getPluginName() {
        return this.pluginName;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public List<Long> getRetryIntervals() {
        return this.retryIntervals;
    }

    public INextTimestampProvider getNextTimestampProvider() {
        return this.nextTimestampProvider;
    }

    public File getPersistentNextDateFile() {
        return this.persistentNextDateFile;
    }

    private static final INextTimestampProvider createNextTimestampProvider(String runScheduleDescription) {
        if (runScheduleDescription.startsWith(CRON_PREFIX)) {
            CronSequenceGenerator cronSequenceGenerator = new CronSequenceGenerator(runScheduleDescription.substring(CRON_PREFIX.length()));
            return new CronSequenceBaseNextTimestampProvider(cronSequenceGenerator);
        }
        return new NextTimestampProviderCollection(runScheduleDescription);
    }

    private static class AnyDay
    implements INextDay {
        private AnyDay() {
        }

        @Override
        public boolean isValidDay(GregorianCalendar calendar) {
            return true;
        }

        @Override
        public void setNextPossibleDay(GregorianCalendar calendar) {
            this.setNextPossibleDay(calendar, 1);
        }

        protected void setNextPossibleDay(GregorianCalendar calendar, int diff) {
            calendar.set(6, calendar.get(6) + diff);
        }
    }

    private static class AnyDayFactory
    implements INextDayFactory {
        private AnyDayFactory() {
        }

        @Override
        public boolean accept(List<Object> descriptors) {
            return descriptors.isEmpty();
        }

        @Override
        public INextDay create(List<Object> descriptors) {
            return new AnyDay();
        }
    }

    private static class NextDayInYearFactory
    implements INextDayFactory {
        private NextDayInYearFactory() {
        }

        @Override
        public boolean accept(List<Object> descriptors) {
            return descriptors.size() == 2 && descriptors.get(0) instanceof Integer && (descriptors.get(1) instanceof Integer || descriptors.get(1) instanceof Month);
        }

        @Override
        public INextDay create(List<Object> descriptors) {
            final int monthDay = (Integer)descriptors.get(0);
            final int monthIndex = descriptors.get(1) instanceof Integer ? (Integer)descriptors.get(1) - 1 : ((Month)((Object)descriptors.get(1))).getNumber();
            return new AnyDay(){

                @Override
                public boolean isValidDay(GregorianCalendar calendar) {
                    return calendar.get(5) == monthDay && calendar.get(2) == monthIndex;
                }

                @Override
                public void setNextPossibleDay(GregorianCalendar calendar) {
                    int dayOfYear = calendar.get(6);
                    calendar.set(2, monthIndex);
                    calendar.set(5, monthDay);
                    if (calendar.get(6) <= dayOfYear) {
                        calendar.set(1, calendar.get(1) + 1);
                    }
                }
            };
        }
    }

    private static class NextWeekDayInMonthFactory
    implements INextDayFactory {
        private NextWeekDayInMonthFactory() {
        }

        @Override
        public boolean accept(List<Object> descriptors) {
            return descriptors.size() == 2 && descriptors.get(0) instanceof Integer && descriptors.get(1) instanceof WeekDay;
        }

        @Override
        public INextDay create(List<Object> descriptors) {
            final int weekNumber = (Integer)descriptors.get(0);
            final WeekDay weekDay = (WeekDay)((Object)descriptors.get(1));
            return new AnyDay(){

                @Override
                public boolean isValidDay(GregorianCalendar calendar) {
                    return calendar.get(7) == weekDay.getNumber() && this.getWeekNumber(calendar) == weekNumber;
                }

                @Override
                public void setNextPossibleDay(GregorianCalendar calendar) {
                    int diff = weekDay.getNumber() - calendar.get(7);
                    if (diff <= 0) {
                        diff += 7;
                    }
                    this.setNextPossibleDay(calendar, diff);
                    while (this.getWeekNumber(calendar) != weekNumber) {
                        this.setNextPossibleDay(calendar, 7);
                    }
                }

                private int getWeekNumber(GregorianCalendar calendar) {
                    return calendar.get(5) / 7 + 1;
                }
            };
        }
    }

    private static class NextMonthDayFactory
    implements INextDayFactory {
        private NextMonthDayFactory() {
        }

        @Override
        public boolean accept(List<Object> descriptors) {
            return descriptors.size() == 1 && descriptors.get(0) instanceof Integer;
        }

        @Override
        public INextDay create(List<Object> descriptors) {
            final int monthDay = (Integer)descriptors.get(0);
            return new AnyDay(){

                @Override
                public boolean isValidDay(GregorianCalendar calendar) {
                    return calendar.get(5) == monthDay;
                }

                @Override
                public void setNextPossibleDay(GregorianCalendar calendar) {
                    int diff = monthDay - calendar.get(5);
                    if (diff <= 0) {
                        diff += calendar.getActualMaximum(5);
                    }
                    this.setNextPossibleDay(calendar, diff);
                }
            };
        }
    }

    private static class NextWeekDayFactory
    implements INextDayFactory {
        private NextWeekDayFactory() {
        }

        @Override
        public boolean accept(List<Object> descriptors) {
            return descriptors.size() == 1 && descriptors.get(0) instanceof WeekDay;
        }

        @Override
        public INextDay create(List<Object> descriptors) {
            final WeekDay weekDay = (WeekDay)((Object)descriptors.get(0));
            return new AnyDay(){

                @Override
                public boolean isValidDay(GregorianCalendar calendar) {
                    return calendar.get(7) == weekDay.getNumber();
                }

                @Override
                public void setNextPossibleDay(GregorianCalendar calendar) {
                    int diff = weekDay.getNumber() - calendar.get(7);
                    if (diff <= 0) {
                        diff += 7;
                    }
                    this.setNextPossibleDay(calendar, diff);
                }
            };
        }
    }

    private static interface INextDayFactory {
        public boolean accept(List<Object> var1);

        public INextDay create(List<Object> var1);
    }

    private static interface INextDay {
        public boolean isValidDay(GregorianCalendar var1);

        public void setNextPossibleDay(GregorianCalendar var1);
    }

    private static enum Month {
        JAN(0),
        FEB(1),
        MAR(2),
        APR(3),
        MAY(4),
        JUN(5),
        JUL(6),
        AUG(7),
        SEP(8),
        OCT(9),
        NOV(10),
        DEC(11);

        private int number;

        private Month(int number) {
            this.number = number;
        }

        public int getNumber() {
            return this.number;
        }

        static Month get(String string) {
            for (Month month : Month.values()) {
                if (!month.toString().equalsIgnoreCase(string)) continue;
                return month;
            }
            return null;
        }
    }

    private static enum WeekDay {
        SU(1),
        SUN(1),
        MO(2),
        MON(2),
        TU(3),
        TUE(3),
        WE(4),
        WED(4),
        TH(5),
        THU(5),
        FR(6),
        FRI(6),
        SA(7),
        SAT(7);

        private int number;

        private WeekDay(int number) {
            this.number = number;
        }

        public int getNumber() {
            return this.number;
        }

        static WeekDay get(String string) {
            for (WeekDay weekDay : WeekDay.values()) {
                if (!weekDay.toString().equalsIgnoreCase(string)) continue;
                return weekDay;
            }
            return null;
        }
    }

    private static final class SimpleNextTimestampProvider
    implements INextTimestampProvider {
        private static final INextDayFactory[] NEXT_DAY_FACTORIES = new INextDayFactory[]{new NextWeekDayFactory(), new NextMonthDayFactory(), new NextWeekDayInMonthFactory(), new NextDayInYearFactory(), new AnyDayFactory()};
        private int hour;
        private int minute;
        private INextDay nextDay;

        SimpleNextTimestampProvider(String definition) {
            try {
                String[] splitted = StringUtils.split((String)definition);
                String[] splittedTime = splitted[splitted.length - 1].split(":");
                this.hour = Integer.parseInt(splittedTime[0]);
                this.minute = splittedTime.length > 1 ? Integer.parseInt(splittedTime[1]) : 0;
                this.nextDay = this.createNextDay(splitted);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Invalid property 'run-schedule' (Reason: " + e.getMessage() + "): " + definition, e);
            }
        }

        private INextDay createNextDay(String[] splitted) {
            ArrayList<Object> descriptors = new ArrayList<Object>();
            if (splitted.length > 1) {
                for (int i = 0; i < splitted.length - 1; ++i) {
                    String[] stringArray = splitted[i].split("\\.");
                    int n = stringArray.length;
                    for (int j = 0; j < n; ++j) {
                        String string = stringArray[j];
                        this.parseDescriptor(descriptors, string);
                    }
                }
            }
            for (INextDayFactory factory : NEXT_DAY_FACTORIES) {
                if (!factory.accept(descriptors)) continue;
                return factory.create(descriptors);
            }
            throw new IllegalArgumentException("Invalid description");
        }

        private void parseDescriptor(List<Object> descriptors, String descriptorString) {
            try {
                descriptors.add(Integer.parseInt(descriptorString));
            }
            catch (NumberFormatException e) {
                WeekDay weekDay = WeekDay.get(descriptorString);
                if (weekDay != null) {
                    descriptors.add((Object)weekDay);
                }
                Month month = Month.get(descriptorString);
                if (month != null) {
                    descriptors.add((Object)month);
                }
                throw new IllegalArgumentException("Neither a number nor a 3-letter month nor a 2-letter week day nor a 3-letter week day: " + descriptorString);
            }
        }

        @Override
        public Date getNextTimestamp(Date timestamp) {
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTimeInMillis(timestamp.getTime() / 1000L * 1000L);
            calendar.set(11, this.hour);
            calendar.set(12, this.minute);
            calendar.set(13, 0);
            Date next = calendar.getTime();
            if (this.nextDay.isValidDay(calendar) && next.after(timestamp)) {
                return next;
            }
            this.nextDay.setNextPossibleDay(calendar);
            return calendar.getTime();
        }
    }

    private static final class NextTimestampProviderCollection
    implements INextTimestampProvider {
        private List<INextTimestampProvider> providers = new ArrayList<INextTimestampProvider>();

        NextTimestampProviderCollection(String definition) {
            String[] splittedDefinition;
            for (String def : splittedDefinition = definition.split(",")) {
                this.providers.add(new SimpleNextTimestampProvider(def));
            }
        }

        @Override
        public Date getNextTimestamp(Date timestamp) {
            Date bestNext = null;
            for (INextTimestampProvider provider : this.providers) {
                Date next = provider.getNextTimestamp(timestamp);
                if (bestNext != null && !next.before(bestNext)) continue;
                bestNext = next;
            }
            return bestNext;
        }
    }

    private static final class CronSequenceBaseNextTimestampProvider
    implements INextTimestampProvider {
        private CronSequenceGenerator cronSequenceGenerator;

        CronSequenceBaseNextTimestampProvider(CronSequenceGenerator cronSequenceGenerator) {
            this.cronSequenceGenerator = cronSequenceGenerator;
        }

        @Override
        public Date getNextTimestamp(Date timestamp) {
            return this.cronSequenceGenerator.next(timestamp);
        }
    }
}

