/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.net.uniprot;

import ch.systemsx.cisd.common.net.uniprot.UniprotColumn;
import ch.systemsx.cisd.common.parser.ParserException;
import ch.systemsx.cisd.common.time.DateFormatThreadLocal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import org.apache.commons.lang3.StringUtils;

public class UniprotEntry {
    static final String UNIPROT_DATE_FORMAT_PATTERN = "yyyy-MM-dd";
    static final ThreadLocal<SimpleDateFormat> DATE_FORMAT = new DateFormatThreadLocal("yyyy-MM-dd");
    private String citation;
    private String comments;
    private String database;
    private String[] disease;
    private String domains;
    private String domain;
    private String ec;
    private String id;
    private String entryName;
    private String existence;
    private String families;
    private String features;
    private String[] function;
    private String genes;
    private String go;
    private String goId;
    private String interpro;
    private String interactor;
    private String keywords;
    private Date lastModified;
    private Integer length;
    private String organism;
    private String organismId;
    private String pathway;
    private String proteinNames;
    private String status;
    private String score;
    private String sequence;
    private String[] sequenceSimilarities;
    private String subcellularLocations;
    private String[] subUnitStructure;
    private String taxon;
    private String threeD;
    private String[] tissueSpecificity;
    private Integer version;
    private String virusHosts;

    public String getCitation() {
        return this.citation;
    }

    void setCitation(String citation) {
        this.citation = citation;
    }

    public String getComments() {
        return this.comments;
    }

    void setComments(String comments) {
        this.comments = comments;
    }

    public String getDatabase() {
        return this.database;
    }

    void setDatabase(String database) {
        this.database = database;
    }

    public String getDomains() {
        return this.domains;
    }

    public String[] getDisease() {
        return this.disease;
    }

    private static String toString(String[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 1) {
            return array[0];
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < array.length; ++i) {
            builder.append('(');
            builder.append(i);
            builder.append("): ");
            builder.append(array[i]);
            builder.append('\n');
        }
        return builder.toString();
    }

    public String getDiseaseStr() {
        return UniprotEntry.toString(this.disease);
    }

    void setDisease(String[] disease) {
        this.disease = disease;
    }

    void setDomains(String domains) {
        this.domains = domains;
    }

    public String getDomain() {
        return this.domain;
    }

    void setDomain(String domain) {
        this.domain = domain;
    }

    public String getEc() {
        return this.ec;
    }

    void setEc(String ec) {
        this.ec = ec;
    }

    public String getId() {
        return this.id;
    }

    void setId(String id) {
        this.id = id;
    }

    public String getEntryName() {
        return this.entryName;
    }

    void setEntryName(String entryName) {
        this.entryName = entryName;
    }

    public String getExistence() {
        return this.existence;
    }

    void setExistence(String existence) {
        this.existence = existence;
    }

    public String getFamilies() {
        return this.families;
    }

    void setFamilies(String families) {
        this.families = families;
    }

    public String getFeatures() {
        return this.features;
    }

    void setFeatures(String features) {
        this.features = features;
    }

    public String getGenes() {
        return this.genes;
    }

    public String[] getFunction() {
        return this.function;
    }

    public String getFunctionStr() {
        return UniprotEntry.toString(this.function);
    }

    void setFunction(String[] function) {
        this.function = function;
    }

    void setGenes(String genes) {
        this.genes = genes;
    }

    public String getGo() {
        return this.go;
    }

    void setGo(String go) {
        this.go = go;
    }

    public String getGoId() {
        return this.goId;
    }

    void setGoId(String goId) {
        this.goId = goId;
    }

    public String getInterpro() {
        return this.interpro;
    }

    void setInterpro(String interpro) {
        this.interpro = interpro;
    }

    public String getInteractor() {
        return this.interactor;
    }

    void setInteractor(String interactor) {
        this.interactor = interactor;
    }

    public String getKeywords() {
        return this.keywords;
    }

    void setKeywords(String keywords) {
        this.keywords = keywords;
    }

    public Date getLastModified() {
        return this.lastModified;
    }

    public String getLastModifiedStr() {
        return DATE_FORMAT.get().format(this.lastModified);
    }

    void setLastModified(Date lastModified) {
        this.lastModified = lastModified;
    }

    public Integer getLength() {
        return this.length;
    }

    void setLength(Integer length) {
        this.length = length;
    }

    public String getOrganism() {
        return this.organism;
    }

    void setOrganism(String organism) {
        this.organism = organism;
    }

    public String getOrganismId() {
        return this.organismId;
    }

    void setOrganismId(String organismId) {
        this.organismId = organismId;
    }

    public String getPathway() {
        return this.pathway;
    }

    void setPathway(String pathway) {
        this.pathway = pathway;
    }

    public String getProteinNames() {
        return this.proteinNames;
    }

    void setProteinNames(String proteinNames) {
        this.proteinNames = proteinNames;
    }

    public String getStatus() {
        return this.status;
    }

    void setStatus(String status) {
        this.status = status;
    }

    public String getScore() {
        return this.score;
    }

    void setScore(String score) {
        this.score = score;
    }

    public String getSequence() {
        return this.sequence;
    }

    void setSequence(String sequence) {
        this.sequence = sequence;
    }

    public String getThreeD() {
        return this.threeD;
    }

    void setThreeD(String threeD) {
        this.threeD = threeD;
    }

    public String getSubcellularLocations() {
        return this.subcellularLocations;
    }

    void setSubcellularLocations(String subcellularLocations) {
        this.subcellularLocations = subcellularLocations;
    }

    public String getTaxon() {
        return this.taxon;
    }

    void setTaxon(String taxon) {
        this.taxon = taxon;
    }

    public String[] getTissueSpecificity() {
        return this.tissueSpecificity;
    }

    void setTissueSpecificity(String[] tissueSpecificity) {
        this.tissueSpecificity = tissueSpecificity;
    }

    public String getTissueSpecificityStr() {
        return UniprotEntry.toString(this.tissueSpecificity);
    }

    public Integer getVersion() {
        return this.version;
    }

    void setVersion(Integer version) {
        this.version = version;
    }

    public String getVirusHosts() {
        return this.virusHosts;
    }

    void setVirusHosts(String virusHosts) {
        this.virusHosts = virusHosts;
    }

    public String[] getSequenceSimilarities() {
        return this.sequenceSimilarities;
    }

    public String getSequenceSimilaritiesStr() {
        return UniprotEntry.toString(this.sequenceSimilarities);
    }

    void setSequenceSimilarities(String[] sequenceSimilarities) {
        this.sequenceSimilarities = sequenceSimilarities;
    }

    public String[] getSubUnitStructure() {
        return this.subUnitStructure;
    }

    public String getSubUnitStructureStr() {
        return UniprotEntry.toString(this.subUnitStructure);
    }

    void setSubUnitStructure(String[] subUnitStructure) {
        this.subUnitStructure = subUnitStructure;
    }

    private String[] parse(UniprotColumn column, String value) {
        if (StringUtils.isBlank((CharSequence)value) || column.getPrefix() == null) {
            return null;
        }
        int prefixLength = column.getPrefix().length();
        int oldIndex = 0;
        int newIndex = value.indexOf(column.getPrefix(), oldIndex);
        LinkedList<Integer> indices = new LinkedList<Integer>();
        while (newIndex >= 0) {
            indices.add(newIndex);
            oldIndex = newIndex + prefixLength;
            newIndex = value.indexOf(column.getPrefix(), oldIndex);
        }
        String[] values = new String[indices.size()];
        for (int i = 0; i < indices.size() - 1; ++i) {
            values[i] = StringUtils.trim((String)value.substring((Integer)indices.get(i) + prefixLength, (Integer)indices.get(i + 1)));
        }
        if (indices.size() > 0) {
            values[indices.size() - 1] = StringUtils.trim((String)value.substring((Integer)indices.get(indices.size() - 1) + prefixLength));
        }
        return values;
    }

    void set(UniprotColumn column, String value) {
        switch (column) {
            case CITATION: {
                this.setCitation(value);
                break;
            }
            case COMMENTS: {
                this.setComments(value);
                break;
            }
            case DATABASE: {
                this.setDatabase(value);
                break;
            }
            case DISEASE: {
                this.setDisease(this.parse(UniprotColumn.DISEASE, value));
                break;
            }
            case DOMAIN: {
                this.setDomain(value);
                break;
            }
            case DOMAINS: {
                this.setDomains(value);
                break;
            }
            case EC: {
                this.setEc(value);
                break;
            }
            case ENTRY_NAME: {
                this.setEntryName(value);
                break;
            }
            case EXISTENCE: {
                this.setExistence(value);
                break;
            }
            case FAMILIES: {
                this.setFamilies(value);
                break;
            }
            case FEATURES: {
                this.setFeatures(value);
                break;
            }
            case FUNCTION: {
                this.setFunction(this.parse(UniprotColumn.FUNCTION, value));
                break;
            }
            case GENES: {
                this.setGenes(value);
                break;
            }
            case GO: {
                this.setGo(value);
                break;
            }
            case GO_ID: {
                this.setGoId(value);
                break;
            }
            case ID: {
                this.setId(value);
                break;
            }
            case INTERACTOR: {
                this.setInteractor(value);
                break;
            }
            case INTERPRO: {
                this.setInterpro(value);
                break;
            }
            case KEYWORDS: {
                this.setKeywords(value);
                break;
            }
            case LAST_MODIFIED: {
                if (!StringUtils.isNotBlank((CharSequence)value)) break;
                try {
                    this.setLastModified(DATE_FORMAT.get().parse(value));
                    break;
                }
                catch (ParseException ex) {
                    throw new ParserException("Error parsing date: " + value, ex);
                }
            }
            case LENGTH: {
                if (!StringUtils.isNotBlank((CharSequence)value)) break;
                this.setLength(Integer.parseInt(value));
                break;
            }
            case ORGANISM: {
                this.setOrganism(value);
                break;
            }
            case ORGANISM_ID: {
                this.setOrganismId(value);
                break;
            }
            case PATHWAY: {
                this.setPathway(value);
                break;
            }
            case PROTEIN_NAMES: {
                this.setProteinNames(value);
                break;
            }
            case SCORE: {
                this.setScore(value);
                break;
            }
            case SEQUENCE: {
                this.setSequence(value);
                break;
            }
            case SEQUENCE_SIMILARITIES: {
                this.setSequenceSimilarities(this.parse(UniprotColumn.SEQUENCE_SIMILARITIES, value));
                break;
            }
            case STATUS: {
                this.setStatus(value);
                break;
            }
            case SUBCELLULAR_LOCATIONS: {
                this.setSubcellularLocations(value);
                break;
            }
            case SUBUNIT_STRUCTURE: {
                this.setSubUnitStructure(this.parse(UniprotColumn.SUBUNIT_STRUCTURE, value));
                break;
            }
            case TAXON: {
                this.setTaxon(value);
                break;
            }
            case TISSUE_SPECIFITY: {
                this.setTissueSpecificity(this.parse(UniprotColumn.TISSUE_SPECIFITY, value));
                break;
            }
            case THREED: {
                this.setThreeD(value);
                break;
            }
            case VERSION: {
                if (!StringUtils.isNotBlank((CharSequence)value)) break;
                this.setVersion(Integer.parseInt(value));
                break;
            }
            case VIRUS_HOSTS: {
                this.setVirusHosts(value);
            }
        }
    }
}

