/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.net.uniprot;

import ch.systemsx.cisd.common.net.uniprot.UniprotColumn;
import ch.systemsx.cisd.common.net.uniprot.UniprotEntry;
import ch.systemsx.cisd.common.parser.IParserObjectFactory;
import ch.systemsx.cisd.common.parser.IPropertyMapper;
import ch.systemsx.cisd.common.parser.IPropertyModel;
import ch.systemsx.cisd.common.parser.ParserException;
import java.util.Set;

final class UniprotEntryParserFactory
implements IParserObjectFactory<UniprotEntry> {
    private final UniprotColumn[] columns;

    UniprotEntryParserFactory(IPropertyMapper mapper) {
        Set<String> columnHeaders = mapper.getAllPropertyCodes();
        this.columns = new UniprotColumn[columnHeaders.size()];
        for (String columnHeader : columnHeaders) {
            IPropertyModel model = mapper.getPropertyModel(columnHeader);
            UniprotColumn col = UniprotColumn.columnMap.get(model.getCode().toLowerCase());
            if (col == null) {
                throw new ParserException("Unknown Uniprot column header: '" + model.getCode() + "'");
            }
            this.columns[model.getColumn()] = col;
        }
    }

    @Override
    public UniprotEntry createObject(String[] lineTokens) throws ParserException {
        assert (lineTokens.length == this.columns.length);
        UniprotEntry result = new UniprotEntry();
        for (int i = 0; i < this.columns.length; ++i) {
            UniprotColumn column = this.columns[i];
            result.set(column, lineTokens[i]);
        }
        return result;
    }
}

