/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.net.uniprot;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.base.exceptions.IOExceptionUnchecked;
import ch.systemsx.cisd.common.http.JettyHttpClientFactory;
import ch.systemsx.cisd.common.net.uniprot.UniprotColumn;
import ch.systemsx.cisd.common.net.uniprot.UniprotEntry;
import ch.systemsx.cisd.common.net.uniprot.UniprotEntryParserFactory;
import ch.systemsx.cisd.common.parser.IParserObjectFactory;
import ch.systemsx.cisd.common.parser.IParserObjectFactoryFactory;
import ch.systemsx.cisd.common.parser.IPropertyMapper;
import ch.systemsx.cisd.common.parser.ParserException;
import ch.systemsx.cisd.common.parser.TabFileLoader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.compress.utils.IOUtils;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.util.InputStreamResponseListener;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpStatus;

public final class UniprotQuery {
    private static final String BASE_URL = "http://www.uniprot.org/uniprot/";
    private static final String QUERY_INIT_STR = "query=";
    private static final String COLUMN_INIT_STR = "columns=";
    private static final String FORMAT_STR = "format=tab";
    private static final String OFFSET_STR = "offset=";
    private static final String LIMIT_STR = "limit=";
    private final String columnsSpecification;

    public static Set<UniprotColumn> columns(UniprotColumn ... columns) {
        EnumSet<UniprotColumn> set = EnumSet.noneOf(UniprotColumn.class);
        for (UniprotColumn col : columns) {
            set.add(col);
        }
        return set;
    }

    public UniprotQuery(UniprotColumn ... columns) {
        this(UniprotQuery.columns(columns));
    }

    public UniprotQuery(Set<UniprotColumn> columns) {
        columns.add(UniprotColumn.ID);
        this.columnsSpecification = this.createColumnSpecification(columns);
    }

    private String createColumnSpecification(Set<UniprotColumn> columns) {
        StringBuilder builder = new StringBuilder();
        builder.append(COLUMN_INIT_STR);
        for (UniprotColumn col : columns) {
            builder.append(col.getFieldName());
            builder.append(',');
        }
        builder.setLength(builder.length() - 1);
        return builder.toString();
    }

    private String buildQueryURLForKeys(List<String> keys) {
        StringBuilder builder = new StringBuilder();
        builder.append(BASE_URL);
        builder.append('?');
        builder.append(QUERY_INIT_STR);
        for (String key : keys) {
            builder.append("accession:");
            builder.append(key);
            builder.append("+or+");
        }
        builder.setLength(builder.length() - "+or+".length());
        builder.append('&');
        builder.append(FORMAT_STR);
        builder.append('&');
        builder.append(this.columnsSpecification);
        return builder.toString();
    }

    private String buildQueryURLForQueryExpression(String queryExpression, int limit, int offset) {
        StringBuilder builder = new StringBuilder();
        builder.append(BASE_URL);
        builder.append('?');
        builder.append(QUERY_INIT_STR);
        builder.append(queryExpression.replaceAll(" ", "%20"));
        builder.append('&');
        builder.append(FORMAT_STR);
        builder.append('&');
        builder.append(this.columnsSpecification);
        if (limit > 0) {
            builder.append('&');
            builder.append(LIMIT_STR);
            builder.append(Integer.toString(limit));
        }
        if (offset > 0) {
            builder.append('&');
            builder.append(OFFSET_STR);
            builder.append(Integer.toString(offset));
        }
        return builder.toString();
    }

    private Iterable<UniprotEntry> runQuery(String queryURL) throws IOExceptionUnchecked {
        InputStreamResponseListener listener = new InputStreamResponseListener();
        Request request = JettyHttpClientFactory.getHttpClient().newRequest(queryURL).method(HttpMethod.GET);
        final InputStream stream = listener.getInputStream();
        try {
            request.send((Response.CompleteListener)listener);
            Response response = listener.get(5L, TimeUnit.SECONDS);
            if (response.getStatus() != HttpStatus.Code.OK.getCode()) {
                throw new IOExceptionUnchecked(new IOException("GET failed: " + response.getStatus() + ": " + response.getReason()));
            }
            final TabFileLoader<UniprotEntry> parser = new TabFileLoader<UniprotEntry>(new IParserObjectFactoryFactory<UniprotEntry>(){

                @Override
                public IParserObjectFactory<UniprotEntry> createFactory(IPropertyMapper propertyMapper) throws ParserException {
                    return new UniprotEntryParserFactory(propertyMapper);
                }
            });
            return new Iterable<UniprotEntry>(){
                boolean hasIterated = false;

                @Override
                public Iterator<UniprotEntry> iterator() {
                    try {
                        if (this.hasIterated) {
                            throw new IllegalStateException();
                        }
                        this.hasIterated = true;
                        return new Iterator<UniprotEntry>(){
                            Map<String, String> defauts = Collections.emptyMap();
                            final Iterator<UniprotEntry> delegate;
                            {
                                this.delegate = parser.iterate(stream, this.defauts);
                            }

                            @Override
                            public boolean hasNext() {
                                boolean hasNext = this.delegate.hasNext();
                                if (!hasNext) {
                                    IOUtils.closeQuietly((Closeable)stream);
                                }
                                return hasNext;
                            }

                            @Override
                            public UniprotEntry next() {
                                try {
                                    return this.delegate.next();
                                }
                                catch (RuntimeException ex) {
                                    IOUtils.closeQuietly((Closeable)stream);
                                    throw ex;
                                }
                            }

                            @Override
                            public void remove() {
                                IOUtils.closeQuietly((Closeable)stream);
                                throw new UnsupportedOperationException();
                            }
                        };
                    }
                    catch (Exception ex) {
                        IOUtils.closeQuietly((Closeable)stream);
                        throw CheckedExceptionTunnel.wrapIfNecessary(ex);
                    }
                }
            };
        }
        catch (Exception ex) {
            IOUtils.closeQuietly((Closeable)stream);
            throw CheckedExceptionTunnel.wrapIfNecessary(ex);
        }
    }

    public Iterable<UniprotEntry> queryForIds(String ... keys) throws IOExceptionUnchecked {
        return this.queryForIds(Arrays.asList(keys));
    }

    public Iterable<UniprotEntry> queryForIds(List<String> keys) throws IOExceptionUnchecked {
        String queryURL = this.buildQueryURLForKeys(keys);
        return this.runQuery(queryURL);
    }

    public Iterable<UniprotEntry> query(String queryExpression) throws IOExceptionUnchecked {
        String queryURL = this.buildQueryURLForQueryExpression(queryExpression, 0, 0);
        return this.runQuery(queryURL);
    }

    public Iterable<UniprotEntry> query(String queryExpression, int limit, int offset) throws IOExceptionUnchecked {
        String queryURL = this.buildQueryURLForQueryExpression(queryExpression, limit, offset);
        return this.runQuery(queryURL);
    }
}

