/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.parser;

import ch.systemsx.cisd.common.parser.BeanProperty;
import ch.systemsx.cisd.common.reflection.AnnotationUtils;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;

final class BeanAnalyzer<T> {
    private final Class<T> beanClass;
    private final Set<String> mandatoryProperties = new TreeSet<String>();
    private final Set<String> optionalProperties = new TreeSet<String>();
    private final Map<String, Method> labelToWriteMethods = new HashMap<String, Method>();

    BeanAnalyzer(Class<T> beanClass) {
        this.beanClass = beanClass;
        this.fillProperties();
    }

    private final void fillProperties() {
        List<Method> annotatedMethods = AnnotationUtils.getAnnotatedMethodList(this.beanClass, BeanProperty.class);
        for (Method method : annotatedMethods) {
            BeanAnalyzer.checkMethod(method);
            BeanProperty annotation = method.getAnnotation(BeanProperty.class);
            String label = annotation.label();
            assert (StringUtils.isNotEmpty((CharSequence)label)) : String.format("BeanProperty annotation's label is not specified for method '%s'", method.getName());
            this.labelToWriteMethods.put(label, method);
            boolean optional = annotation.optional();
            this.checkUnique(label, optional);
            if (optional) {
                this.optionalProperties.add(label);
                continue;
            }
            this.mandatoryProperties.add(label);
        }
    }

    private static final void checkMethod(Method method) {
        Class<?> returnType = method.getReturnType();
        assert (returnType.equals(Void.TYPE)) : String.format("Return value of method '%s' must be void.", method.getName());
        Class<?>[] parameterTypes = method.getParameterTypes();
        assert (parameterTypes.length == 1) : String.format("Annotated method '%s' must only accept one parameter.", method.getName());
    }

    private final void checkUnique(String fieldName, boolean optional) {
        assert (!this.optionalProperties.contains(fieldName) && !this.mandatoryProperties.contains(fieldName)) : String.format("%s bean property '%s' already found and must be unique.", optional ? "Optional" : "Mandatory", fieldName);
    }

    final boolean isMandatory(String property) {
        return this.mandatoryProperties.contains(property);
    }

    final Set<String> getMandatoryProperties() {
        return Collections.unmodifiableSet(this.mandatoryProperties);
    }

    final Set<String> getOptionalProperties() {
        return Collections.unmodifiableSet(this.optionalProperties);
    }

    final Map<String, Method> getLabelToWriteMethods() {
        return Collections.unmodifiableMap(this.labelToWriteMethods);
    }
}

