/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.parser;

import ch.systemsx.cisd.common.parser.ColumnSizeMismatchException;
import ch.systemsx.cisd.common.parser.DefaultLineTokenizer;
import ch.systemsx.cisd.common.parser.ILine;
import ch.systemsx.cisd.common.parser.ILineTokenizer;
import ch.systemsx.cisd.common.parser.IParser;
import ch.systemsx.cisd.common.parser.IParserObjectFactory;
import ch.systemsx.cisd.common.parser.ParserException;
import ch.systemsx.cisd.common.parser.ParsingException;
import ch.systemsx.cisd.common.parser.filter.ILineFilter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.commons.lang3.StringUtils;

public class DefaultParser<E, T>
implements IParser<E, T> {
    private final ILineTokenizer<T> lineTokenizer;
    private IParserObjectFactory<E> factory;

    public static <E> DefaultParser<E, String> createDefaultParser() {
        return new DefaultParser<E, String>(new DefaultLineTokenizer());
    }

    public DefaultParser(ILineTokenizer<T> lineTokenizer) {
        this.lineTokenizer = lineTokenizer;
    }

    protected E createObject(String[] tokens) throws ParserException {
        return this.factory.createObject(tokens);
    }

    @Override
    public final List<E> parse(Iterator<ILine<T>> lineIterator, ILineFilter lineFilter, int headerLength) throws ParsingException {
        ArrayList<Object> elements = new ArrayList<Object>();
        this.lineTokenizer.init();
        while (lineIterator.hasNext()) {
            ILine<T> line = lineIterator.next();
            T nextLine = line.getObject();
            int number = line.getNumber();
            if (!lineFilter.acceptLine(line)) continue;
            Object object = null;
            String[] tokens = this.parseLine(number, nextLine, headerLength);
            if (this.areAllTokensBlank(tokens)) continue;
            try {
                object = this.createObject(tokens);
            }
            catch (ParserException parserException) {
                throw new ParsingException(parserException, tokens, number);
            }
            if (null == object) continue;
            elements.add(object);
        }
        this.lineTokenizer.destroy();
        return elements;
    }

    private boolean areAllTokensBlank(String[] tokens) {
        for (String token : tokens) {
            if (StringUtils.isBlank((CharSequence)token)) continue;
            return false;
        }
        return true;
    }

    @Override
    public final Iterator<E> parseIteratively(final Iterator<ILine<T>> lineIterator, final ILineFilter lineFilter, final int headerLength) throws ParsingException {
        this.lineTokenizer.init();
        return new Iterator<E>(){
            ILine<T> currentLine = null;

            @Override
            public boolean hasNext() {
                boolean hasNext = lineIterator.hasNext();
                while (hasNext) {
                    this.currentLine = (ILine)lineIterator.next();
                    if (lineFilter.acceptLine(this.currentLine)) break;
                    hasNext = lineIterator.hasNext();
                }
                if (!hasNext) {
                    this.currentLine = null;
                    DefaultParser.this.lineTokenizer.destroy();
                }
                return hasNext;
            }

            @Override
            public E next() {
                if (this.currentLine == null && !this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Object nextLine = this.currentLine.getObject();
                int number = this.currentLine.getNumber();
                this.currentLine = null;
                String[] tokens = DefaultParser.this.parseLine(number, nextLine, headerLength);
                try {
                    return DefaultParser.this.createObject(tokens);
                }
                catch (ParserException parserException) {
                    throw new ParsingException(parserException, tokens, number);
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public final void setObjectFactory(IParserObjectFactory<E> factory) {
        this.factory = factory;
    }

    private String[] parseLine(int lineNumber, T nextLine, int headerLength) {
        String[] tokens = this.lineTokenizer.tokenize(nextLine);
        if (tokens.length > headerLength) {
            throw new ColumnSizeMismatchException(tokens, lineNumber, headerLength);
        }
        if (tokens.length < headerLength) {
            String[] newTokens = new String[headerLength];
            System.arraycopy(tokens, 0, newTokens, 0, tokens.length);
            for (int i = tokens.length; i < headerLength; ++i) {
                newTokens[i] = "";
            }
            tokens = newTokens;
        }
        return tokens;
    }
}

