/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.parser;

import ch.systemsx.cisd.common.parser.ExcelRowTokenizer;
import ch.systemsx.cisd.common.parser.ILine;
import org.apache.poi.ss.usermodel.Row;

public class ExcelRow
implements ILine<Row> {
    private Row row;
    private String text;

    public ExcelRow(Row row) {
        this.row = row;
    }

    @Override
    public String getText() {
        if (this.text == null) {
            this.text = ExcelRow.toString(this.row);
        }
        return this.text;
    }

    @Override
    public int getNumber() {
        return this.row.getRowNum();
    }

    @Override
    public Row getObject() {
        return this.row;
    }

    private static String toString(Row row) {
        StringBuilder sb = new StringBuilder();
        for (String s : new ExcelRowTokenizer().tokenize(row)) {
            if (s.length() > 0) {
                sb.append("\t");
            }
            sb.append(s);
        }
        return sb.toString();
    }
}

