/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.parser;

import ch.systemsx.cisd.common.parser.ILine;
import ch.systemsx.cisd.common.parser.Line;
import ch.systemsx.cisd.common.parser.ParserException;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.csv.CSVRecord;

public class MultilineSupport {
    public static CSVFormat FORMAT = CSVFormat.DEFAULT.withHeader((String[])null).withDelimiter('\t').withRecordSeparator('\n');

    public static ClosableMapIterator<CSVRecord, ILine<String>> addTo(Iterator<ILine<String>> lineIterator) throws IOException {
        final CSVParser csvParser = new CSVParser((Reader)new ChainReader((Iterator<CharArrayReader>)new MapIterator<ILine<String>, CharArrayReader>(lineIterator){

            @Override
            CharArrayReader convert(ILine<String> t) {
                return new CharArrayReader((t.getText() + "\n").toCharArray());
            }
        }), FORMAT);
        return new ClosableMapIterator<CSVRecord, ILine<String>>(csvParser.iterator()){
            int row;
            {
                super(iter);
                this.row = 0;
            }

            @Override
            ILine<String> convert(CSVRecord t) {
                Line line;
                Iterator iterator = t.iterator();
                StringWriter sw = new StringWriter();
                CSVPrinter printer = new CSVPrinter((Appendable)sw, FORMAT);
                try {
                    ArrayList<String> data = new ArrayList<String>();
                    while (iterator.hasNext()) {
                        data.add((String)iterator.next());
                    }
                    printer.printRecord(data);
                    ++this.row;
                    line = new Line(this.row, sw.getBuffer().toString());
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            printer.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new ParserException(e.getMessage(), e);
                    }
                }
                printer.close();
                return line;
            }

            @Override
            public void close() throws Exception {
                csvParser.close();
            }
        };
    }

    private static class ChainReader
    extends Reader {
        private Iterator<CharArrayReader> iter;
        private CharArrayReader current = null;

        public ChainReader(Iterator<CharArrayReader> iter) {
            this.iter = iter;
        }

        @Override
        public int read(char[] cbuf, int off, int len) throws IOException {
            int readSoFar = 0;
            while (readSoFar < len) {
                int amount;
                if (this.current == null) {
                    if (!this.iter.hasNext()) break;
                    this.current = this.iter.next();
                }
                if ((amount = this.current.read(cbuf, off + readSoFar, len - readSoFar)) == -1) {
                    this.current.close();
                    this.current = null;
                    continue;
                }
                readSoFar += amount;
            }
            if (readSoFar == 0) {
                return -1;
            }
            return readSoFar;
        }

        @Override
        public void close() throws IOException {
            if (this.current != null) {
                this.current.close();
            }
        }
    }

    private static abstract class MapIterator<FROM, TO>
    implements Iterator<TO> {
        private Iterator<FROM> iter;

        abstract TO convert(FROM var1);

        public MapIterator(Iterator<FROM> iter) {
            this.iter = iter;
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public TO next() {
            return this.convert(this.iter.next());
        }

        @Override
        public void remove() {
            this.iter.remove();
        }
    }

    private static abstract class ClosableMapIterator<FROM, TO>
    extends MapIterator<FROM, TO>
    implements AutoCloseable {
        public ClosableMapIterator(Iterator<FROM> iter) {
            super(iter);
        }
    }
}

