/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.parser;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PercentFormatter {
    private static final Pattern pattern = Pattern.compile("([0-9]+)\\s*\\%");

    public static int parse(String percent) {
        Matcher m = pattern.matcher(percent);
        if (m.matches()) {
            return Integer.valueOf(m.group(1));
        }
        throw new IllegalArgumentException("Could not parse percent value: " + percent);
    }

    public static String format(int percent) {
        if (percent < 0) {
            throw new IllegalArgumentException("Percent value has to greater than or equal to 0");
        }
        return percent + "%";
    }
}

