/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.process;

import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Semaphore;

public final class InputStreamReaderGobbler {
    private final Semaphore waitForReadingFinishedSemaphore = new Semaphore(1);
    private final List<String> lines = new ArrayList<String>();

    public InputStreamReaderGobbler(final InputStream stream) throws InterruptedException {
        this.waitForReadingFinishedSemaphore.acquire();
        Thread t = new Thread(){

            @Override
            public final void run() {
                try {
                    String line;
                    BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
                    while ((line = reader.readLine()) != null) {
                        InputStreamReaderGobbler.this.lines.add(line);
                    }
                }
                catch (IOException ex) {
                    throw new EnvironmentFailureException("Couldn't gobble stream content", ex);
                }
                finally {
                    InputStreamReaderGobbler.this.waitForReadingFinishedSemaphore.release();
                }
            }
        };
        t.start();
    }

    public final List<String> getLines() throws InterruptedException {
        this.waitForReadingFinishedSemaphore.acquire();
        try {
            List<String> list = this.lines;
            return list;
        }
        finally {
            this.waitForReadingFinishedSemaphore.release();
        }
    }
}

