/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.process;

import ch.systemsx.cisd.base.exceptions.InterruptedExceptionUnchecked;
import ch.systemsx.cisd.common.process.IProcessHandler;
import ch.systemsx.cisd.common.process.ProcessExecutor;
import ch.systemsx.cisd.common.process.ProcessIOStrategy;
import ch.systemsx.cisd.common.process.ProcessResult;
import ch.systemsx.cisd.common.utilities.AddToListTextHandler;
import ch.systemsx.cisd.common.utilities.ITextHandler;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public final class ProcessExecutionHelper {
    public static final int RECOMMENDED_BUFFER_SIZE = 4096;

    public static final boolean log(ProcessResult result) throws InterruptedExceptionUnchecked {
        result.log();
        if (result.isInterruped()) {
            throw new InterruptedExceptionUnchecked();
        }
        return result.isOK();
    }

    public static ProcessResult run(List<String> cmd, Logger operationLog, Logger machineLog, boolean stopOnInterrupt) throws InterruptedExceptionUnchecked {
        return new ProcessExecutor(cmd, null, false, -1L, false, ProcessIOStrategy.DEFAULT_IO_STRATEGY, operationLog, machineLog, null, null).run(stopOnInterrupt);
    }

    public static ProcessResult run(List<String> cmd, Logger operationLog, Logger machineLog) throws InterruptedExceptionUnchecked {
        return ProcessExecutionHelper.run(cmd, operationLog, machineLog, true);
    }

    public static boolean runAndLog(List<String> cmd, Logger operationLog, Logger machineLog) throws InterruptedExceptionUnchecked {
        return ProcessExecutionHelper.log(ProcessExecutionHelper.run(cmd, operationLog, machineLog, false));
    }

    public static boolean runAndLog(List<String> cmd, Logger operationLog, Logger machineLog, long millisToWaitForCompletion) throws InterruptedExceptionUnchecked {
        return ProcessExecutionHelper.log(ProcessExecutionHelper.run(cmd, operationLog, machineLog, millisToWaitForCompletion, false));
    }

    public static ProcessResult run(List<String> cmd, Logger operationLog, Logger machineLog, long millisToWaitForCompletion, boolean stopOnInterrupt) throws InterruptedExceptionUnchecked {
        return new ProcessExecutor(cmd, null, false, millisToWaitForCompletion, false, ProcessIOStrategy.DEFAULT_IO_STRATEGY, operationLog, machineLog, null, null).run(stopOnInterrupt);
    }

    public static ProcessResult run(List<String> cmd, Logger operationLog, Logger machineLog, long millisToWaitForCompletion, boolean doNotTimeoutWhenIO, boolean stopOnInterrupt) throws InterruptedExceptionUnchecked {
        return new ProcessExecutor(cmd, null, false, millisToWaitForCompletion, doNotTimeoutWhenIO, ProcessIOStrategy.DEFAULT_IO_STRATEGY, operationLog, machineLog, null, null).run(stopOnInterrupt);
    }

    public static ProcessResult run(List<String> cmd, Logger operationLog, Logger machineLog, long millisToWaitForCompletion, ProcessIOStrategy ioStrategy, boolean stopOnInterrupt) throws InterruptedExceptionUnchecked {
        return new ProcessExecutor(cmd, null, false, millisToWaitForCompletion, false, ioStrategy, operationLog, machineLog, null, null).run(stopOnInterrupt);
    }

    public static ProcessResult run(List<String> cmd, Logger operationLog, Logger machineLog, long millisToWaitForCompletion, boolean doNotTimeoutWhenIO, ProcessIOStrategy ioStrategy, boolean stopOnInterrupt) throws InterruptedExceptionUnchecked {
        return new ProcessExecutor(cmd, null, false, millisToWaitForCompletion, doNotTimeoutWhenIO, ioStrategy, operationLog, machineLog, null, null).run(stopOnInterrupt);
    }

    public static ProcessResult run(List<String> cmd, Map<String, String> environment, boolean replaceEnvironment, Logger operationLog, Logger machineLog, long millisToWaitForCompletion, ProcessIOStrategy ioStrategy, boolean stopOnInterrupt) throws InterruptedExceptionUnchecked {
        return new ProcessExecutor(cmd, environment, replaceEnvironment, millisToWaitForCompletion, false, ioStrategy, operationLog, machineLog, null, null).run(stopOnInterrupt);
    }

    public static ProcessResult run(List<String> cmd, Map<String, String> environment, boolean replaceEnvironment, Logger operationLog, Logger machineLog, long millisToWaitForCompletion, boolean doNotTimeoutWhenIO, ProcessIOStrategy ioStrategy, boolean stopOnInterrupt) throws InterruptedExceptionUnchecked {
        return new ProcessExecutor(cmd, environment, replaceEnvironment, millisToWaitForCompletion, doNotTimeoutWhenIO, ioStrategy, operationLog, machineLog, null, null).run(stopOnInterrupt);
    }

    public static ProcessResult run(List<String> cmd, Logger operationLog, Logger machineLog, long millisToWaitForCompletion) throws InterruptedExceptionUnchecked {
        return ProcessExecutionHelper.run(cmd, operationLog, machineLog, millisToWaitForCompletion, true);
    }

    public static boolean runAndLog(List<String> cmd, Logger operationLog, Logger machineLog, long millisToWaitForCompletion, ProcessIOStrategy processIOStrategy) throws InterruptedExceptionUnchecked {
        return ProcessExecutionHelper.log(ProcessExecutionHelper.run(cmd, operationLog, machineLog, millisToWaitForCompletion, processIOStrategy, false));
    }

    public static boolean runAndLog(List<String> cmd, Map<String, String> environment, boolean replaceEnvironment, Logger operationLog, Logger machineLog, long millisToWaitForCompletion, ProcessIOStrategy processIOStrategy) throws InterruptedExceptionUnchecked {
        return ProcessExecutionHelper.log(ProcessExecutionHelper.run(cmd, environment, replaceEnvironment, operationLog, machineLog, millisToWaitForCompletion, processIOStrategy, false));
    }

    public static IProcessHandler runNonblocking(List<String> cmd, Logger operationLog, Logger machineLog, ProcessIOStrategy processIOStrategy, ITextHandler stdoutHandlerOrNull, ITextHandler stderrHandlerOrNull) {
        return new ProcessExecutor(cmd, null, false, -1L, false, processIOStrategy, operationLog, machineLog, stdoutHandlerOrNull, stderrHandlerOrNull).runUnblocking();
    }

    public static IProcessHandler runNonblocking(List<String> cmd, Map<String, String> environment, boolean replaceEnvironment, Logger operationLog, Logger machineLog, ProcessIOStrategy processIOStrategy, ITextHandler stdoutHandlerOrNull, ITextHandler stderrHandlerOrNull) {
        return new ProcessExecutor(cmd, environment, replaceEnvironment, -1L, false, processIOStrategy, operationLog, machineLog, stdoutHandlerOrNull, stderrHandlerOrNull).runUnblocking();
    }

    public static boolean readTextIfAvailable(BufferedReader reader, List<String> outputOrNull, boolean discard) throws IOException {
        return ProcessExecutionHelper.readTextIfAvailable(reader, new AddToListTextHandler(outputOrNull), discard);
    }

    static boolean readTextIfAvailable(BufferedReader reader, ITextHandler textHandler, boolean discard) throws IOException {
        boolean readText = false;
        while (reader.ready()) {
            String line = reader.readLine();
            if (line == null) {
                return readText;
            }
            readText = true;
            if (discard) continue;
            textHandler.handle(line);
        }
        return readText;
    }

    public static long readBytesIfAvailable(InputStream input, OutputStream outputOrNull, byte[] buffer, long maxBytes, boolean discard) throws IOException {
        long count;
        int n = 0;
        for (count = 0L; (maxBytes <= 0L || count < maxBytes) && input.available() > 0 && -1 != (n = input.read(buffer)); count += (long)n) {
            if (discard) continue;
            outputOrNull.write(buffer, 0, n);
        }
        return count;
    }

    static final String getCommandName(List<String> commandLine) {
        return new File(commandLine.get(0)).getName();
    }
}

