/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.properties;

import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.common.utilities.IExitHandler;
import ch.systemsx.cisd.common.utilities.SystemExit;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;

public class PropertiesFileMerger {
    public static void main(String[] args) {
        PropertiesFileMerger.main(args, SystemExit.SYSTEM_EXIT);
    }

    @Private
    static void main(String[] args, IExitHandler exitHandler) {
        if (args.length == 0) {
            System.err.println("Usage: java " + PropertiesFileMerger.class.getName() + " <properties file> <overloading properties file 1> <overloading properties file 2> ...");
            exitHandler.exit(1);
        }
        File propertiesFile = new File(args[0]);
        PropertiesFileMerger.check(propertiesFile, exitHandler);
        File[] overloadingPropertiesFiles = new File[args.length - 1];
        for (int i = 1; i < args.length; ++i) {
            File overloadingPropertiesFile = new File(args[i]);
            PropertiesFileMerger.check(overloadingPropertiesFile, exitHandler);
            overloadingPropertiesFiles[i - 1] = overloadingPropertiesFile;
        }
        PropertiesFileMerger.mergePropertiesFiles(propertiesFile, overloadingPropertiesFiles);
    }

    private static void check(File propertiesFile, IExitHandler exitHandler) {
        if (!propertiesFile.isFile()) {
            System.err.println("Isn't a file or does not exist: " + propertiesFile);
            exitHandler.exit(1);
        }
    }

    public static void mergePropertiesFiles(File propertiesFile, File ... overloadingPropertiesFiles) {
        if (overloadingPropertiesFiles.length == 0) {
            return;
        }
        try {
            Entries entries = new Entries();
            PropertiesFileMerger.load(propertiesFile, entries);
            for (File overloadingPropertiesFile : overloadingPropertiesFiles) {
                PropertiesFileMerger.load(overloadingPropertiesFile, entries);
            }
            PrintWriter printWriter = null;
            try {
                printWriter = new PrintWriter(propertiesFile);
                for (Entry entry : entries.getEntries()) {
                    if (entry.getType() == EntryType.PROPERTY) {
                        printWriter.println(entry.getKey() + " = " + entry.getValue());
                        continue;
                    }
                    printWriter.println(entry.getLine());
                }
            }
            catch (Exception ex) {
                try {
                    throw CheckedExceptionTunnel.wrapIfNecessary(ex);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(printWriter);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((Writer)printWriter);
        }
        catch (NotSimpleKeyValuePairException ex) {
            PropertiesFileMerger.concatenateFiles(propertiesFile, overloadingPropertiesFiles);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void concatenateFiles(File propertiesFile, File ... overloadingPropertieFiles) {
        FileWriter writer = null;
        try {
            writer = new FileWriter(propertiesFile, true);
            for (File overloadingPropertiesFile : overloadingPropertieFiles) {
                writer.write("\n");
                FileReader reader = null;
                try {
                    reader = new FileReader(overloadingPropertiesFile);
                    IOUtils.copy((Reader)reader, (Writer)writer);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(reader);
                    throw throwable;
                }
                IOUtils.closeQuietly((Reader)reader);
            }
        }
        catch (IOException ex1) {
            try {
                throw CheckedExceptionTunnel.wrapIfNecessary(ex1);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(writer);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Writer)writer);
    }

    private static void load(File propertiesFile, Entries entries) {
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new FileReader(propertiesFile));
            while ((line = reader.readLine()) != null) {
                entries.addLine(line);
            }
        }
        catch (IOException ex) {
            try {
                throw CheckedExceptionTunnel.wrapIfNecessary(ex);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(reader);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Reader)reader);
    }

    private static final class Entries {
        private final List<Entry> entries = new ArrayList<Entry>();
        private final Map<String, Entry> entryMap = new HashMap<String, Entry>();

        private Entries() {
        }

        void addLine(String line) {
            Entry entry = new Entry(line);
            if (entry.getType() == EntryType.PROPERTY) {
                Entry existingEntry = this.entryMap.get(entry.getKey());
                if (existingEntry != null) {
                    existingEntry.setValue(entry.getValue());
                } else {
                    this.entries.add(entry);
                    this.entryMap.put(entry.getKey(), entry);
                }
            } else {
                this.entries.add(entry);
            }
        }

        public List<Entry> getEntries() {
            return this.entries;
        }
    }

    private static final class Entry {
        private final String line;
        private final EntryType type;
        private String key;
        private String value;

        Entry(String line) {
            this.line = line;
            String trimmedLine = line.trim();
            if (trimmedLine.length() == 0 || trimmedLine.startsWith("#")) {
                this.type = EntryType.COMMENT;
            } else {
                this.type = EntryType.PROPERTY;
                int indexOfEqualSign = line.indexOf(61);
                if (indexOfEqualSign < 0) {
                    throw new NotSimpleKeyValuePairException();
                }
                this.key = line.substring(0, indexOfEqualSign).trim();
                this.value = line.substring(indexOfEqualSign + 1).trim();
            }
        }

        public String getLine() {
            return this.line;
        }

        public EntryType getType() {
            return this.type;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }

    private static final class NotSimpleKeyValuePairException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
    }

    private static enum EntryType {
        COMMENT,
        PROPERTY;

    }
}

