/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.serviceconversation.server;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.base.exceptions.InterruptedExceptionUnchecked;
import ch.systemsx.cisd.base.exceptions.TimeoutExceptionUnchecked;
import ch.systemsx.cisd.common.serviceconversation.IServiceMessageTransport;
import ch.systemsx.cisd.common.serviceconversation.ServiceMessage;
import ch.systemsx.cisd.common.serviceconversation.UnexpectedMessagePayloadException;
import ch.systemsx.cisd.common.serviceconversation.server.IInternalServiceMessenger;
import ch.systemsx.cisd.common.serviceconversation.server.ProgressInfo;
import ch.systemsx.cisd.common.serviceconversation.server.ServiceConversationServer;
import java.io.Serializable;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

class BidirectionalServiceMessenger {
    private final BlockingQueue<ServiceMessage> incoming = new LinkedBlockingQueue<ServiceMessage>();
    private final String conversationId;
    private final IServiceMessageTransport responseMessenger;
    private final int messageReceivingTimeoutMillis;
    private int messageIdxLastSeen = -1;
    private final AtomicBoolean interrupted = new AtomicBoolean();
    private final IInternalServiceMessenger serviceMessenger;

    BidirectionalServiceMessenger(String conversationId, int messageReceivingTimeoutMillis, IServiceMessageTransport responseMessenger) {
        this.conversationId = conversationId;
        this.messageReceivingTimeoutMillis = messageReceivingTimeoutMillis;
        this.responseMessenger = responseMessenger;
        this.serviceMessenger = this.createServiceMessenger();
    }

    private IInternalServiceMessenger createServiceMessenger() {
        return new IInternalServiceMessenger(){
            private int outgoingMessageIdx;

            private int nextOutgoingMessageIndex() {
                return this.outgoingMessageIdx++;
            }

            @Override
            public <T extends Serializable> T receive(Class<T> messageClass) {
                T payload = this.tryReceive(messageClass, BidirectionalServiceMessenger.this.messageReceivingTimeoutMillis);
                if (payload == null) {
                    String msg = "Timeout while waiting for message from client.";
                    ServiceConversationServer.operationLog.error((Object)String.format("[id: %s] %s", BidirectionalServiceMessenger.this.conversationId, "Timeout while waiting for message from client."));
                    throw new TimeoutExceptionUnchecked("Timeout while waiting for message from client.");
                }
                return payload;
            }

            @Override
            public <T extends Serializable> T tryReceive(Class<T> messageClass, int timeoutMillis) {
                Serializable payload;
                if (BidirectionalServiceMessenger.this.interrupted.get()) {
                    throw new InterruptedExceptionUnchecked();
                }
                try {
                    ServiceMessage message = (ServiceMessage)BidirectionalServiceMessenger.this.incoming.poll(timeoutMillis, TimeUnit.MILLISECONDS);
                    if (message == null) {
                        return null;
                    }
                    payload = message.getPayload();
                }
                catch (InterruptedException ex) {
                    throw CheckedExceptionTunnel.wrapIfNecessary(ex);
                }
                if (messageClass != null && !messageClass.isAssignableFrom(payload.getClass())) {
                    throw new UnexpectedMessagePayloadException(payload.getClass(), messageClass);
                }
                return (T)payload;
            }

            @Override
            public synchronized void send(Serializable message) {
                if (BidirectionalServiceMessenger.this.interrupted.get()) {
                    throw new InterruptedExceptionUnchecked();
                }
                BidirectionalServiceMessenger.this.responseMessenger.send(new ServiceMessage(BidirectionalServiceMessenger.this.conversationId, this.nextOutgoingMessageIndex(), false, message));
            }

            @Override
            public synchronized void sendException(String errorMsg) {
                BidirectionalServiceMessenger.this.responseMessenger.send(new ServiceMessage(BidirectionalServiceMessenger.this.conversationId, this.nextOutgoingMessageIndex(), true, (Serializable)((Object)errorMsg)));
            }

            @Override
            public synchronized void sendProgress(ProgressInfo progress) {
                BidirectionalServiceMessenger.this.responseMessenger.send(new ServiceMessage(BidirectionalServiceMessenger.this.conversationId, this.nextOutgoingMessageIndex(), progress));
            }

            @Override
            public String getId() {
                return BidirectionalServiceMessenger.this.conversationId;
            }
        };
    }

    IInternalServiceMessenger getServiceMessenger() {
        return this.serviceMessenger;
    }

    public void sendToService(ServiceMessage message) {
        if (message.getMessageIdx() <= this.messageIdxLastSeen) {
            return;
        }
        this.messageIdxLastSeen = message.getMessageIdx();
        this.incoming.add(message);
    }

    public void markAsInterrupted() {
        this.interrupted.set(true);
    }

    public boolean isMarkedAsInterrupted() {
        return this.interrupted.get();
    }
}

