/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.ssl;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.net.URL;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class SslCertificateHelper {
    private final String serviceURL;
    private final File keystoreFile;
    private final String certificateEntryName;

    public SslCertificateHelper(String serviceURL, File keystoreFile, String certificateEntryName) {
        this.serviceURL = serviceURL;
        this.keystoreFile = keystoreFile;
        this.certificateEntryName = certificateEntryName;
    }

    public void setUpKeyStore() {
        if (this.serviceURL.startsWith("https")) {
            KeyStore keyStore;
            Certificate[] certificates = this.getServerCertificate();
            try {
                keyStore = KeyStore.getInstance("JKS");
                keyStore.load(null, null);
                for (int i = 0; i < certificates.length; ++i) {
                    keyStore.setCertificateEntry(this.certificateEntryName + i, certificates[i]);
                }
            }
            catch (Exception ex) {
                throw CheckedExceptionTunnel.wrapIfNecessary(ex);
            }
            FileOutputStream fileOutputStream = null;
            try {
                fileOutputStream = new FileOutputStream(this.keystoreFile);
                keyStore.store(fileOutputStream, "changeit".toCharArray());
                fileOutputStream.close();
                System.setProperty("javax.net.ssl.trustStore", this.keystoreFile.getAbsolutePath());
            }
            catch (Exception ex) {
                try {
                    throw CheckedExceptionTunnel.wrapIfNecessary(ex);
                }
                catch (Throwable throwable) {
                    SslCertificateHelper.closeQuietly(fileOutputStream);
                    throw throwable;
                }
            }
            SslCertificateHelper.closeQuietly(fileOutputStream);
        }
    }

    private static void closeQuietly(OutputStream output) {
        try {
            if (output != null) {
                output.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private Certificate[] getServerCertificate() {
        this.workAroundABugInJava6();
        this.setUpAllAcceptingTrustManager();
        this.setUpAllAcceptingHostNameVerifier();
        Socket socket = null;
        try {
            URL url = new URL(this.serviceURL);
            int port = url.getPort();
            if (port == -1) {
                port = 443;
            }
            String hostname = url.getHost();
            SSLSocketFactory factory = HttpsURLConnection.getDefaultSSLSocketFactory();
            socket = (SSLSocket)factory.createSocket(hostname, port);
            ((SSLSocket)socket).startHandshake();
            Certificate[] certificateArray = ((SSLSocket)socket).getSession().getPeerCertificates();
            return certificateArray;
        }
        catch (Exception e) {
            throw CheckedExceptionTunnel.wrapIfNecessary(e);
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void setUpAllAcceptingTrustManager() {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        try {
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setUpAllAcceptingHostNameVerifier() {
        HostnameVerifier acceptAllHostNames = new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        };
        HttpsURLConnection.setDefaultHostnameVerifier(acceptAllHostNames);
    }

    private void workAroundABugInJava6() {
        try {
            SSLContext.getInstance("SSL").createSSLEngine();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void trustAnyCertificate(String url) {
        if (url.startsWith("https://")) {
            try {
                File tempKeyStore = File.createTempFile("cert", "keystore");
                tempKeyStore.deleteOnExit();
                SslCertificateHelper helper = new SslCertificateHelper(url, tempKeyStore, "cert");
                helper.setUpKeyStore();
            }
            catch (IOException ioex) {
                throw CheckedExceptionTunnel.wrapIfNecessary(ioex);
            }
        }
    }
}

