/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.string;

import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public final class UnicodeUtils {
    public static final String UTF_8 = "UTF-8";
    public static final String UTF_16 = "UTF-16";
    public static final String UTF_32 = "UTF-32";
    public static final String DEFAULT_UNICODE_CHARSET = "UTF-8";
    private static final Map<String, byte[]> supportedEncodings = new HashMap<String, byte[]>();

    private UnicodeUtils() {
    }

    public static final Charset getDefaultUnicodeCharset() {
        return Charset.forName("UTF-8");
    }

    private static final String getEncoding(BufferedInputStream bufferedInputStream) {
        try {
            if (bufferedInputStream.markSupported()) {
                for (String encoding : supportedEncodings.keySet()) {
                    byte[] BOM = supportedEncodings.get(encoding);
                    byte[] BOMTest = new byte[BOM.length];
                    bufferedInputStream.mark(BOM.length);
                    bufferedInputStream.read(BOMTest, 0, BOM.length);
                    bufferedInputStream.reset();
                    if (!Arrays.equals(BOM, BOMTest)) continue;
                    String javaEncoding = encoding.split(" ")[0];
                    return javaEncoding;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static final Reader createReader(InputStream inputStream) throws EnvironmentFailureException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        String encoding = UnicodeUtils.getEncoding(bufferedInputStream);
        if (encoding == null) {
            encoding = "UTF-8";
        }
        return UnicodeUtils.createReader(bufferedInputStream, encoding);
    }

    public static final Reader createReader(InputStream inputStream, String encoding) throws EnvironmentFailureException {
        try {
            return new InputStreamReader(inputStream, encoding);
        }
        catch (UnsupportedEncodingException ex) {
            throw new EnvironmentFailureException(ex.getMessage());
        }
    }

    static {
        supportedEncodings.put("UTF-8", new byte[]{-17, -69, -65});
        supportedEncodings.put("UTF-16 LE", new byte[]{-1, -2});
        supportedEncodings.put("UTF-16 BE", new byte[]{-2, -1});
        supportedEncodings.put("UTF-32 LE", new byte[]{-2, -1, 0, 0});
        supportedEncodings.put("UTF-32 BE", new byte[]{0, 0, -2, -1});
    }
}

