/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.common.api.server;

import ch.systemsx.cisd.common.api.IRpcServiceNameServer;
import ch.systemsx.cisd.common.api.RpcServiceInterfaceDTO;
import ch.systemsx.cisd.common.api.RpcServiceInterfaceVersionDTO;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class RpcServiceNameServer
implements IRpcServiceNameServer {
    private final ArrayList<RpcServiceInterfaceDTO> supportedInterfaces = new ArrayList();
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, RpcServiceNameServer.class);

    RpcServiceNameServer() {
    }

    public List<RpcServiceInterfaceDTO> getSupportedInterfaces() {
        return this.supportedInterfaces;
    }

    @Override
    public int getMajorVersion() {
        return 1;
    }

    @Override
    public int getMinorVersion() {
        return 0;
    }

    private void addSupportedInterface(RpcServiceInterfaceDTO iface) {
        this.supportedInterfaces.add(iface);
    }

    public void addSupportedInterfaceVersion(RpcServiceInterfaceVersionDTO ifaceVersion) {
        RpcServiceInterfaceDTO iface = null;
        for (RpcServiceInterfaceDTO supportedIface : this.supportedInterfaces) {
            if (!supportedIface.getInterfaceName().equals(ifaceVersion.getInterfaceName())) continue;
            iface = supportedIface;
        }
        if (null == iface) {
            iface = new RpcServiceInterfaceDTO(ifaceVersion.getInterfaceName());
            this.addSupportedInterface(iface);
        }
        iface.addVersion(ifaceVersion);
        operationLog.info((Object)("[rpc-name-server] Registered Interface Version " + ifaceVersion.toString()));
    }
}

