/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.common.api.server.json.deserializer;

import ch.systemsx.cisd.base.annotation.JsonObject;
import ch.systemsx.cisd.openbis.common.api.server.json.common.JsonConstants;
import ch.systemsx.cisd.openbis.common.api.server.json.deserializer.JsonTypeAndClassDeserializer;
import ch.systemsx.cisd.openbis.common.api.server.json.mapping.IJsonClassValueToClassObjectsMapping;
import ch.systemsx.cisd.openbis.common.api.server.json.mapping.JsonStaticClassValueToClassObjectsMapping;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.cfg.DeserializerFactoryConfig;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.deser.BeanDeserializerFactory;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeIdResolver;
import com.fasterxml.jackson.databind.jsontype.impl.TypeNameIdResolver;
import com.fasterxml.jackson.databind.type.ArrayType;
import com.fasterxml.jackson.databind.type.CollectionLikeType;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.MapLikeType;
import com.fasterxml.jackson.databind.type.MapType;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;

public class JsonDeserializerFactory
extends BeanDeserializerFactory {
    private IJsonClassValueToClassObjectsMapping classValueToClassObjectsMapping = new JsonStaticClassValueToClassObjectsMapping();

    public JsonDeserializerFactory(IJsonClassValueToClassObjectsMapping classValueToClassObjectsMapping) {
        super(new DeserializerFactoryConfig());
        this.classValueToClassObjectsMapping = classValueToClassObjectsMapping;
    }

    public JsonDeserializer<?> createArrayDeserializer(DeserializationContext ctxt, ArrayType type, BeanDescription beanDesc) throws JsonMappingException {
        ArrayType newType = type.withContentTypeHandler((Object)this.createContentTypeDeserializer(ctxt, (JavaType)type, beanDesc));
        return super.createArrayDeserializer(ctxt, newType, beanDesc);
    }

    public JsonDeserializer<?> createCollectionDeserializer(DeserializationContext ctxt, CollectionType type, BeanDescription beanDesc) throws JsonMappingException {
        CollectionType newType = type.withContentTypeHandler((Object)this.createContentTypeDeserializer(ctxt, (JavaType)type, beanDesc));
        return super.createCollectionDeserializer(ctxt, newType, beanDesc);
    }

    public JsonDeserializer<?> createCollectionLikeDeserializer(DeserializationContext ctxt, CollectionLikeType type, BeanDescription beanDesc) throws JsonMappingException {
        CollectionLikeType newType = type.withContentTypeHandler((Object)this.createContentTypeDeserializer(ctxt, (JavaType)type, beanDesc));
        return super.createCollectionLikeDeserializer(ctxt, newType, beanDesc);
    }

    public JsonDeserializer<?> createMapDeserializer(DeserializationContext ctxt, MapType type, BeanDescription beanDesc) throws JsonMappingException {
        MapType newType = type.withContentTypeHandler((Object)this.createContentTypeDeserializer(ctxt, (JavaType)type, beanDesc));
        return super.createMapDeserializer(ctxt, newType, beanDesc);
    }

    public JsonDeserializer<?> createMapLikeDeserializer(DeserializationContext ctxt, MapLikeType type, BeanDescription beanDesc) throws JsonMappingException {
        MapLikeType newType = type.withContentTypeHandler((Object)this.createContentTypeDeserializer(ctxt, (JavaType)type, beanDesc));
        return super.createMapLikeDeserializer(ctxt, newType, beanDesc);
    }

    private TypeDeserializer createContentTypeDeserializer(DeserializationContext ctxt, JavaType containerType, BeanDescription beanDesc) {
        JavaType contentType = containerType.getContentType();
        if (contentType == null || contentType.getRawClass() == null) {
            return null;
        }
        Class contentClass = contentType.getRawClass();
        if (contentClass.equals(Object.class) || contentClass.isAnnotationPresent(JsonObject.class) && !contentClass.isEnum()) {
            DeserializationConfig config = ctxt.getConfig();
            BeanDescription bean = config.introspectClassAnnotations(contentType.getRawClass());
            AnnotatedClass ac = bean.getClassInfo();
            AnnotationIntrospector ai = config.getAnnotationIntrospector();
            Collection subtypes = config.getSubtypeResolver().collectAndResolveSubtypes(ac, (MapperConfig)config, ai);
            TypeNameIdResolver resolver = TypeNameIdResolver.construct((MapperConfig)config, (JavaType)contentType, (Collection)subtypes, (boolean)false, (boolean)true);
            JsonTypeAndClassWithFallbackDeserializer deserializer = new JsonTypeAndClassWithFallbackDeserializer(contentType, subtypes, (TypeIdResolver)resolver, JsonConstants.getTypeField());
            deserializer.setClassValueToClassObjectsMapping(this.classValueToClassObjectsMapping);
            return deserializer;
        }
        return null;
    }

    private class JsonTypeAndClassWithFallbackDeserializer
    extends JsonTypeAndClassDeserializer {
        public JsonTypeAndClassWithFallbackDeserializer(JsonTypeAndClassWithFallbackDeserializer src, BeanProperty property) {
            super(src, property);
        }

        public JsonTypeAndClassWithFallbackDeserializer(JavaType type, Collection<NamedType> subtypes, TypeIdResolver idRes, String typePropName) {
            super(type, subtypes, idRes, typePropName, false);
        }

        @Override
        public TypeDeserializer forProperty(BeanProperty prop) {
            return new JsonTypeAndClassWithFallbackDeserializer(this, prop);
        }

        @Override
        public Object deserializeTypedFromObject(JsonParser parser, DeserializationContext ctxt) throws IOException {
            String json = this.parserToString(parser);
            JsonFactory factory = new JsonFactory(parser.getCodec());
            try {
                JsonParser jp1 = factory.createJsonParser(json);
                jp1.nextToken();
                return super.deserializeTypedFromObject(jp1, ctxt);
            }
            catch (IOException e) {
                try {
                    JsonParser jp2 = factory.createJsonParser(json);
                    jp2.nextToken();
                    return super.deserializeWithoutType(jp2, ctxt, null);
                }
                catch (IOException e2) {
                    throw new IllegalArgumentException("Could not deserialize object.\nAttempt of deserialization with type failed with: \n" + e + "\nAttempt of deserialization without type failed with: \n" + e2);
                }
            }
        }

        private String parserToString(JsonParser parser) {
            try {
                JsonFactory factory = new JsonFactory(parser.getCodec());
                StringWriter writer = new StringWriter();
                JsonGenerator generator = factory.createJsonGenerator((Writer)writer);
                generator.setCodec(parser.getCodec());
                JsonNode node = (JsonNode)parser.readValueAs(JsonNode.class);
                generator.writeTree((TreeNode)node);
                return writer.toString();
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
        }
    }
}

