/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.common.api.server.json.introspector;

import ch.systemsx.cisd.base.annotation.JsonObject;
import ch.systemsx.cisd.openbis.common.api.server.json.common.JsonConstants;
import ch.systemsx.cisd.openbis.common.api.server.json.mapping.IJsonClassValueToClassObjectsMapping;
import ch.systemsx.cisd.openbis.common.api.server.json.resolver.JsonTypeAndClassResolverBuilder;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import com.fasterxml.jackson.annotation.SimpleObjectIdResolver;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import com.fasterxml.jackson.databind.introspect.ObjectIdInfo;
import com.fasterxml.jackson.databind.jsontype.TypeResolverBuilder;

public class JsonTypeAndClassAnnotationIntrospector
extends JacksonAnnotationIntrospector {
    private IJsonClassValueToClassObjectsMapping classValueToClassObjectsMapping;

    public JsonTypeAndClassAnnotationIntrospector(IJsonClassValueToClassObjectsMapping classValueToClassObjectsMapping) {
        this.classValueToClassObjectsMapping = classValueToClassObjectsMapping;
    }

    public String findTypeName(AnnotatedClass ac) {
        if (ac.getRawType() != null && ac.getRawType().isEnum()) {
            return null;
        }
        JsonObject tn = (JsonObject)this._findAnnotation((Annotated)ac, JsonObject.class);
        return tn == null ? null : tn.value();
    }

    public ObjectIdInfo findObjectIdInfo(Annotated ann) {
        return new ObjectIdInfo(new PropertyName(JsonConstants.getIdField()), Object.class, ObjectIdGenerators.IntSequenceGenerator.class, SimpleObjectIdResolver.class);
    }

    public TypeResolverBuilder<?> findTypeResolver(MapperConfig<?> config, AnnotatedClass ac, JavaType baseType) {
        if (this.useCustomResolver(baseType)) {
            return new JsonTypeAndClassResolverBuilder(this.classValueToClassObjectsMapping);
        }
        return super.findTypeResolver(config, ac, baseType);
    }

    private boolean useCustomResolver(JavaType type) {
        return type.getRawClass().equals(Object.class) || type.getRawClass().isAnnotationPresent(JsonObject.class) && false == type.getRawClass().isEnum();
    }
}

