/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.common.api.server.json.mapping;

import ch.systemsx.cisd.base.annotation.JsonObject;
import ch.systemsx.cisd.openbis.common.api.server.json.mapping.IJsonBaseTypeToSubTypesMapping;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.google.common.base.Predicate;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.reflections.util.FilterBuilder;

public class JsonReflectionsBaseTypeToSubTypesMapping
implements IJsonBaseTypeToSubTypesMapping {
    private Map<Class<?>, Set<NamedType>> baseTypeToSubTypesMap;
    private Set<NamedType> allSubTypesSet;

    public JsonReflectionsBaseTypeToSubTypesMapping(String[] prefixes) {
        this.baseTypeToSubTypesMap = JsonReflectionsBaseTypeToSubTypesMapping.createBaseTypeToSubTypesMap(prefixes);
        this.allSubTypesSet = JsonReflectionsBaseTypeToSubTypesMapping.createAllSubTypesSet(this.baseTypeToSubTypesMap);
    }

    @Override
    public Set<NamedType> getSubTypes(Class<?> baseType) {
        if (Object.class.equals(baseType)) {
            return this.allSubTypesSet;
        }
        return this.baseTypeToSubTypesMap.get(baseType);
    }

    private static Map<Class<?>, Set<NamedType>> createBaseTypeToSubTypesMap(String[] prefixes) {
        ConfigurationBuilder configBuilder = new ConfigurationBuilder();
        FilterBuilder filterBuilder = new FilterBuilder();
        HashSet urls = new HashSet();
        for (String prefix : prefixes) {
            urls.addAll(ClasspathHelper.forPackage((String)prefix, (ClassLoader[])new ClassLoader[0]));
            filterBuilder.include(FilterBuilder.prefix((String)prefix));
        }
        int numberOfUsedCores = Math.max(1, Runtime.getRuntime().availableProcessors() / 2);
        configBuilder.addUrls(urls);
        configBuilder.filterInputsBy((Predicate)filterBuilder);
        configBuilder.setExecutorService(Executors.newFixedThreadPool(numberOfUsedCores));
        Reflections reflections = new Reflections((Configuration)configBuilder);
        Set types = reflections.getTypesAnnotatedWith(JsonObject.class, true);
        HashMap subTypesMap = new HashMap();
        if (types != null) {
            for (Class baseType : types) {
                for (Class subType : types) {
                    if (!baseType.isAssignableFrom(subType)) continue;
                    HashSet<NamedType> subTypes = (HashSet<NamedType>)subTypesMap.get(baseType);
                    if (subTypes == null) {
                        subTypes = new HashSet<NamedType>();
                        subTypesMap.put(baseType, subTypes);
                    }
                    JsonObject subTypeAnnotation = subType.getAnnotation(JsonObject.class);
                    subTypes.add(new NamedType(subType, subTypeAnnotation.value()));
                }
            }
        }
        return subTypesMap;
    }

    private static Set<NamedType> createAllSubTypesSet(Map<Class<?>, Set<NamedType>> baseTypeToSubTypesMap) {
        HashSet<NamedType> allSubTypes = new HashSet<NamedType>();
        for (Set<NamedType> subTypes : baseTypeToSubTypesMap.values()) {
            allSubTypes.addAll(subTypes);
        }
        return allSubTypes;
    }
}

