/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.common.conversation.manager;

import ch.systemsx.cisd.common.serviceconversation.client.IServiceConversation;
import ch.systemsx.cisd.openbis.common.conversation.client.ServiceConversationClientWithConversationTracking;
import ch.systemsx.cisd.openbis.common.conversation.message.ServiceConversationMethodInvocation;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

class ServiceConversationServiceProxy
implements InvocationHandler {
    private ServiceConversationClientWithConversationTracking client;
    private Class<?> serviceInterface;
    private String sessionToken;

    private ServiceConversationServiceProxy(ServiceConversationClientWithConversationTracking client, Class<?> serviceInterface, String sessionToken) {
        this.client = client;
        this.serviceInterface = serviceInterface;
        this.sessionToken = sessionToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Object proxy, Method m, Object[] args) throws Throwable {
        IServiceConversation conversation = null;
        try {
            conversation = this.client.startConversation(this.serviceInterface, this.sessionToken);
            conversation.send(new ServiceConversationMethodInvocation(m.getName(), m.getParameterTypes(), args));
            Serializable serializable = conversation.receive(Serializable.class);
            return serializable;
        }
        finally {
            if (conversation != null) {
                this.client.closeConversation(conversation);
            }
        }
    }

    static <T> T newInstance(ServiceConversationClientWithConversationTracking client, Class<T> serviceInterface, String sessionToken) {
        return (T)Proxy.newProxyInstance(serviceInterface.getClassLoader(), new Class[]{serviceInterface}, (InvocationHandler)new ServiceConversationServiceProxy(client, serviceInterface, sessionToken));
    }
}

