/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.common.conversation.progress;

import ch.systemsx.cisd.base.namedthread.NamingThreadFactory;
import ch.systemsx.cisd.common.serviceconversation.server.ProgressInfo;
import ch.systemsx.cisd.common.serviceconversation.server.ServiceConversationServer;
import ch.systemsx.cisd.openbis.common.conversation.progress.IServiceConversationProgressListener;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ServiceConversationRateLimitedProgressListener
implements IServiceConversationProgressListener {
    private ServiceConversationServer server;
    private String conversationId;
    private ScheduledThreadPoolExecutor executor;
    private Update lastUpdate;
    private int interval;
    private ScheduledFuture<?> future;

    public ServiceConversationRateLimitedProgressListener(ServiceConversationServer server, String conversationId, int reportingInterval) {
        this.server = server;
        this.conversationId = conversationId;
        this.interval = reportingInterval;
        NamingThreadFactory threadFactory = new NamingThreadFactory(Thread.currentThread().getName() + "-rate-limited-progress-listener");
        threadFactory.setCreateDaemonThreads(true);
        this.executor = new ScheduledThreadPoolExecutor(1);
        this.executor.setThreadFactory(threadFactory);
    }

    @Override
    public synchronized void update(String label, int totalItemsToProcess, int numItemsProcessed) {
        if (this.future != null) {
            this.future.cancel(false);
        }
        long lastExecution = 0L;
        if (this.lastUpdate != null) {
            lastExecution = this.lastUpdate.getLastExecution();
        }
        Update update = new Update(this.server, this.conversationId, new ProgressInfo(label, totalItemsToProcess, numItemsProcessed), lastExecution);
        long timeSinceLastExecution = System.currentTimeMillis() - lastExecution;
        this.future = timeSinceLastExecution > (long)this.interval ? this.executor.schedule(update, 0L, TimeUnit.MILLISECONDS) : this.executor.schedule(update, (long)this.interval - timeSinceLastExecution, TimeUnit.MILLISECONDS);
        this.lastUpdate = update;
    }

    @Override
    public synchronized void close() {
        if (this.future != null) {
            this.future.cancel(false);
        }
        this.executor.shutdown();
    }

    private static class Update
    implements Runnable {
        private ServiceConversationServer server;
        private String conversationId;
        private ProgressInfo progress;
        private long lastExecution;

        public Update(ServiceConversationServer server, String conversationId, ProgressInfo progress, long lastExecution) {
            this.server = server;
            this.conversationId = conversationId;
            this.progress = progress;
            this.lastExecution = lastExecution;
        }

        @Override
        public void run() {
            this.lastExecution = System.currentTimeMillis();
            this.server.reportProgress(this.conversationId, this.progress);
        }

        public long getLastExecution() {
            return this.lastExecution;
        }
    }
}

