/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.common.hdf5;

import ch.systemsx.cisd.openbis.common.hdf5.HDF5ContainerReader;
import ch.systemsx.cisd.openbis.common.hdf5.HDF5ContainerWriter;
import ch.systemsx.cisd.openbis.common.hdf5.IHDF5ContainerReader;
import ch.systemsx.cisd.openbis.common.hdf5.IHDF5ContainerWriter;
import java.io.File;

public class HDF5Container {
    private final File hdf5Container;

    public static void disableCaching() {
        HDF5ContainerReader.disableCaching();
    }

    public HDF5Container(File hdf5Container) {
        this.hdf5Container = hdf5Container;
    }

    public File getHDF5File() {
        return this.hdf5Container;
    }

    public IHDF5ContainerReader createSimpleReader() {
        return new HDF5ContainerReader(this.hdf5Container);
    }

    private IHDF5ContainerWriter createSimpleWriter(boolean isContentCompressed) {
        return new HDF5ContainerWriter(this, this.hdf5Container, isContentCompressed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runWriterClient(boolean isContentCompressed, IHDF5WriterClient client) {
        try (IHDF5ContainerWriter writer = this.createSimpleWriter(isContentCompressed);){
            client.runWithSimpleWriter(writer);
        }
    }

    public void runReaderClient(IHDF5ReaderClient client) {
        try (IHDF5ContainerReader reader = this.createSimpleReader();){
            client.runWithSimpleReader(reader);
        }
    }

    public static interface IHDF5ReaderClient {
        public void runWithSimpleReader(IHDF5ContainerReader var1);
    }

    public static interface IHDF5WriterClient {
        public void runWithSimpleWriter(IHDF5ContainerWriter var1);
    }
}

