/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.common.io;

import ch.systemsx.cisd.base.exceptions.IOExceptionUnchecked;
import ch.systemsx.cisd.base.io.ByteBufferRandomAccessFile;
import ch.systemsx.cisd.base.io.IRandomAccessFile;
import ch.systemsx.cisd.common.io.IOUtilities;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContentNode;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.List;

public class ByteArrayBasedContentNode
implements IHierarchicalContentNode {
    private final byte[] byteArray;
    private final String nameOrNull;
    private long lastModified;
    private Integer checksum;

    public ByteArrayBasedContentNode(byte[] byteArray, String nameOrNull) {
        this.byteArray = byteArray;
        this.nameOrNull = nameOrNull;
        this.lastModified = new Date().getTime();
    }

    @Override
    public boolean exists() {
        return true;
    }

    @Override
    public InputStream getInputStream() {
        return new ByteArrayInputStream(this.byteArray);
    }

    @Override
    public String getName() {
        return this.nameOrNull;
    }

    @Override
    public String getRelativePath() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getParentRelativePath() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isDirectory() {
        return false;
    }

    @Override
    public long getLastModified() {
        return this.lastModified;
    }

    @Override
    public List<IHierarchicalContentNode> getChildNodes() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public File getFile() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public File tryGetFile() {
        return null;
    }

    @Override
    public long getFileLength() throws UnsupportedOperationException {
        return this.byteArray.length;
    }

    @Override
    public String getChecksum() throws UnsupportedOperationException {
        return null;
    }

    @Override
    public int getChecksumCRC32() throws UnsupportedOperationException {
        if (this.checksum == null) {
            this.checksum = IOUtilities.getChecksumCRC32(new ByteArrayInputStream(this.byteArray));
        }
        return this.checksum;
    }

    @Override
    public boolean isChecksumCRC32Precalculated() {
        return false;
    }

    @Override
    public IRandomAccessFile getFileContent() throws UnsupportedOperationException, IOExceptionUnchecked {
        return new ByteBufferRandomAccessFile(ByteBuffer.wrap(this.byteArray));
    }
}

