/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.common.io;

import ch.systemsx.cisd.openbis.common.io.FileBasedContentNode;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContentNode;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;

public class ConcatenatedContentInputStream
extends InputStream {
    private static final int EOF = -1;
    private int currentIndex = -1;
    private boolean closed = false;
    private IHierarchicalContentNode[] contents;
    private StreamType currentStreamType;
    private InputStream currentStream;
    private final boolean ignoreNonExistingContents;

    public static IHierarchicalContentNode[] wrap(List<File> files) {
        ArrayList<FileBasedContentNode> list = new ArrayList<FileBasedContentNode>();
        for (File file : files) {
            list.add(new FileBasedContentNode(file));
        }
        return list.toArray(new IHierarchicalContentNode[files.size()]);
    }

    public ConcatenatedContentInputStream(boolean ignoreNonExistingContents, IHierarchicalContentNode ... contents) {
        this.ignoreNonExistingContents = ignoreNonExistingContents;
        this.contents = contents;
    }

    public ConcatenatedContentInputStream(boolean ignoreNonExistingContents, List<IHierarchicalContentNode> contents) {
        this(ignoreNonExistingContents, contents.toArray(new IHierarchicalContentNode[contents.size()]));
    }

    @Override
    public void close() throws IOException {
        this.closeCurrentStream();
        this.closed = true;
    }

    @Override
    public int read() throws IOException {
        int result = this.readCurrent();
        while (result == -1 && !this.closed) {
            this.closeCurrentStream();
            if (StreamType.HEADER_SIZE.equals((Object)this.currentStreamType)) {
                this.currentStreamType = StreamType.HEADER;
                this.currentStream = this.createHeaderStream(this.tryGetCurrentContent());
            } else if (StreamType.HEADER.equals((Object)this.currentStreamType)) {
                this.currentStreamType = StreamType.CONTENT_SIZE;
                this.currentStream = this.createContentSizeStream(this.tryGetCurrentContent());
            } else if (StreamType.CONTENT_SIZE.equals((Object)this.currentStreamType)) {
                this.currentStreamType = StreamType.CONTENT;
                this.currentStream = this.createContentStream(this.tryGetCurrentContent());
            } else {
                ++this.currentIndex;
                if (this.hasCurrentContent()) {
                    this.currentStreamType = StreamType.HEADER_SIZE;
                    this.currentStream = this.createHeaderSizeStream(this.tryGetCurrentContent());
                } else {
                    this.closed = true;
                    return -1;
                }
            }
            result = this.currentStream.read();
        }
        return result;
    }

    private IHierarchicalContentNode tryGetCurrentContent() {
        if (!this.hasCurrentContent()) {
            throw new IllegalStateException("there are no more content to read");
        }
        return this.contents[this.currentIndex];
    }

    private boolean hasCurrentContent() {
        return this.contents != null && this.currentIndex < this.contents.length;
    }

    private int readCurrent() throws IOException {
        return this.closed || this.currentStream == null ? -1 : this.currentStream.read();
    }

    private void closeCurrentStream() {
        ConcatenatedContentInputStream.close(this.currentStream);
        this.currentStream = null;
    }

    protected static ByteArrayInputStream createEmptyStream() {
        return new ByteArrayInputStream(new byte[0]);
    }

    protected InputStream createHeaderSizeStream(IHierarchicalContentNode contentOrNull) throws IOException {
        return ConcatenatedContentInputStream.createEmptyStream();
    }

    protected InputStream createHeaderStream(IHierarchicalContentNode contentOrNull) throws IOException {
        return ConcatenatedContentInputStream.createEmptyStream();
    }

    protected InputStream createContentSizeStream(IHierarchicalContentNode contentOrNull) throws IOException {
        long size = contentOrNull == null || contentOrNull.isDirectory() ? 0L : contentOrNull.getFileLength();
        byte[] data = this.longToBytes(size);
        return new ByteArrayInputStream(data);
    }

    protected InputStream createContentStream(IHierarchicalContentNode currentContentOrNull) {
        InputStream stream = this.ignoreNonExistingContents && (currentContentOrNull == null || !currentContentOrNull.exists() || currentContentOrNull.isDirectory()) ? ConcatenatedContentInputStream.createEmptyStream() : currentContentOrNull.getInputStream();
        return new BufferedInputStream(stream);
    }

    protected byte[] longToBytes(long size) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        dos.writeLong(size);
        dos.flush();
        byte[] data = bos.toByteArray();
        dos.close();
        return data;
    }

    protected byte[] objectToBytes(Object obj) throws IOException {
        ByteArrayOutputStream b = new ByteArrayOutputStream();
        ObjectOutputStream o = new ObjectOutputStream(b);
        o.writeObject(obj);
        o.flush();
        o.close();
        return b.toByteArray();
    }

    private static void close(InputStream streamOrNull) {
        if (streamOrNull != null) {
            try {
                streamOrNull.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    static enum StreamType {
        HEADER_SIZE,
        HEADER,
        CONTENT_SIZE,
        CONTENT;

    }
}

