/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.common.io.hierarchical_content;

import ch.systemsx.cisd.base.exceptions.IOExceptionUnchecked;
import ch.systemsx.cisd.hdf5.h5ar.ArchiveEntry;
import ch.systemsx.cisd.openbis.common.hdf5.IHDF5ContainerReader;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContent;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContentNode;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class HierarchicalContentUtils {
    static final Comparator<IHierarchicalContentNode> DEFAULT_NODE_COMPARATOR = new Comparator<IHierarchicalContentNode>(){

        @Override
        public int compare(IHierarchicalContentNode node1, IHierarchicalContentNode node2) {
            return this.createSortableName(node1).compareTo(this.createSortableName(node2));
        }

        private String createSortableName(IHierarchicalContentNode node) {
            return (node.isDirectory() ? "D" : "F") + node.getName().toUpperCase();
        }
    };

    public static void sortNodes(List<IHierarchicalContentNode> nodes) {
        Collections.sort(nodes, DEFAULT_NODE_COMPARATOR);
    }

    public static InputStream getInputStreamAutoClosingContent(IHierarchicalContentNode node, IHierarchicalContent content) throws IOExceptionUnchecked {
        return new HierarchicalContentClosingInputStream(node.getInputStream(), content);
    }

    static boolean handleHdf5AsFolder(String filename, boolean h5Folders, boolean h5arFolders) {
        return filename.toLowerCase().endsWith("h5") && h5Folders || filename.toLowerCase().endsWith("h5ar") && h5arFolders;
    }

    public static boolean isFileAbstractionOk(IHDF5ContainerReader reader, String groupPath) {
        List<ArchiveEntry> entries = reader.getGroupMembers(groupPath);
        for (ArchiveEntry entry : entries) {
            if (entry.isRegularFile() && !reader.isFileAbstraction(entry)) {
                return false;
            }
            if (!entry.isDirectory()) continue;
            return HierarchicalContentUtils.isFileAbstractionOk(reader, entry.getPath());
        }
        return true;
    }

    static class HierarchicalContentClosingInputStream
    extends FilterInputStream {
        private final IHierarchicalContent hierarchicalContent;

        public HierarchicalContentClosingInputStream(InputStream target, IHierarchicalContent hierarchicalContent) {
            super(target);
            this.hierarchicalContent = hierarchicalContent;
        }

        @Override
        public void close() throws IOException {
            this.hierarchicalContent.close();
            super.close();
        }
    }
}

