/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.common.io.hierarchical_content;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.base.io.IRandomAccessFile;
import ch.systemsx.cisd.common.filesystem.FileUtilities;
import ch.systemsx.cisd.openbis.common.hdf5.IHDF5ContainerReader;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.AbstractHierarchicalContent;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.AbstractHierarchicalDirectoryContentNode;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.AbstractHierarchicalFileContentNode;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.H5FolderFlags;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.HDF5ContainerBasedHierarchicalContentNode;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.HierarchicalContentUtils;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContent;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContentNode;
import de.schlichtherle.io.rof.ReadOnlyFile;
import de.schlichtherle.io.rof.SimpleReadOnlyFile;
import de.schlichtherle.util.zip.BasicZipFile;
import de.schlichtherle.util.zip.ZipEntry;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;

public class ZipBasedHierarchicalContent
extends AbstractHierarchicalContent {
    static final String TEMP_FILE_PREFIX = "dss-unzipped-";
    static final File TEMP_FOLDER = new File(System.getProperty("java.io.tmpdir"));
    private final BasicZipFile zipFile;
    private final IHierarchicalContentNode rootNode;
    private final Map<String, IHierarchicalContentNode> allNodes;
    private final List<File> unzippedFiles;

    private static final String extractName(String relativePath) {
        int indexOfLastDelimiter = relativePath.lastIndexOf(47);
        if (indexOfLastDelimiter < 0) {
            return relativePath;
        }
        return relativePath.substring(indexOfLastDelimiter + 1);
    }

    public ZipBasedHierarchicalContent(File file, List<H5FolderFlags> h5FolderFlags) {
        try {
            NodeManager nodeManager = new NodeManager(this, h5FolderFlags);
            this.zipFile = new BasicZipFile((ReadOnlyFile)new SimpleReadOnlyFile(file), "UTF-8", true, false);
            Enumeration entries = this.zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = (ZipEntry)entries.nextElement();
                nodeManager.handle(this.zipFile, entry);
            }
            this.rootNode = nodeManager.rootNode;
            this.allNodes = nodeManager.allNodes;
            this.unzippedFiles = nodeManager.unzippedFiles;
        }
        catch (Exception ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary(ex);
        }
    }

    @Override
    public IHierarchicalContentNode getRootNode() {
        return this.rootNode;
    }

    @Override
    public IHierarchicalContentNode getNode(String relativePath) throws IllegalArgumentException {
        IHierarchicalContentNode node = this.tryGetNode(relativePath);
        if (node == null) {
            throw new IllegalArgumentException("Resource '" + relativePath + "' does not exist.");
        }
        return node;
    }

    @Override
    public IHierarchicalContentNode tryGetNode(String relativePath) {
        return this.allNodes.get(relativePath);
    }

    @Override
    public void close() {
        try {
            this.zipFile.close();
            for (File unzippedFile : this.unzippedFiles) {
                FileUtilities.delete(unzippedFile);
            }
        }
        catch (IOException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary(ex);
        }
    }

    private static final class NodeManager {
        private final Map<String, ZipContainerNode> containerNodes = new HashMap<String, ZipContainerNode>();
        private final Map<String, IHierarchicalContentNode> allNodes = new HashMap<String, IHierarchicalContentNode>();
        private final List<File> unzippedFiles = new ArrayList<File>();
        private ZipContainerNode rootNode;
        private final IHierarchicalContent hierarchicalContent;
        private boolean h5Folders;
        private boolean h5arFolders;

        public NodeManager(IHierarchicalContent hierarchicalContent, List<H5FolderFlags> h5FolderFlags) {
            this.hierarchicalContent = hierarchicalContent;
            if (h5FolderFlags != null && !h5FolderFlags.isEmpty()) {
                this.h5Folders = h5FolderFlags.get(0).isH5Folders();
                this.h5arFolders = h5FolderFlags.get(0).isH5arFolders();
            }
        }

        void handle(BasicZipFile zipFile, ZipEntry zipEntry) {
            String relativePath = zipEntry.getName();
            if (zipEntry.isDirectory()) {
                String name = zipEntry.getName();
                if (name.endsWith("/")) {
                    name = name.substring(0, name.length() - 1);
                }
                ZipContainerNode contentNode = new ZipContainerNode(name);
                this.linkNode(contentNode, relativePath);
            } else if (HierarchicalContentUtils.handleHdf5AsFolder(relativePath, this.h5Folders, this.h5arFolders)) {
                try {
                    File tempFile = File.createTempFile(ZipBasedHierarchicalContent.TEMP_FILE_PREFIX, ZipBasedHierarchicalContent.extractName(relativePath), TEMP_FOLDER);
                    this.unzippedFiles.add(tempFile);
                    HDF5ContainerNode contentNode = new HDF5ContainerNode(this.hierarchicalContent, tempFile, zipFile, relativePath, zipEntry);
                    this.linkNode(contentNode, relativePath);
                }
                catch (Exception ex) {
                    throw CheckedExceptionTunnel.wrapIfNecessary(ex);
                }
            } else {
                ZipContentNode contentNode = new ZipContentNode(zipFile, zipEntry);
                this.linkNode(contentNode, relativePath);
            }
        }

        private void linkNode(IHierarchicalContentNode contentNode, String relativePath) {
            this.allNodes.put(relativePath, contentNode);
            String parentRelativePath = FileUtilities.getParentRelativePath(relativePath);
            if (parentRelativePath != null) {
                ZipContainerNode containerNode = this.containerNodes.get(parentRelativePath);
                if (containerNode == null) {
                    containerNode = new ZipContainerNode(parentRelativePath);
                    this.containerNodes.put(parentRelativePath, containerNode);
                    if (parentRelativePath.length() == 0) {
                        this.rootNode = containerNode;
                    } else {
                        this.linkNode(containerNode, parentRelativePath);
                    }
                }
                containerNode.children.add(contentNode);
            }
        }
    }

    private static final class HDF5ContainerNode
    extends HDF5ContainerBasedHierarchicalContentNode {
        private final BasicZipFile zipFile;
        private final String relativePath;
        private final ZipEntry zipEntry;
        private boolean loaded;

        private HDF5ContainerNode(IHierarchicalContent root, File hdf5ContainerFile, BasicZipFile zipFile, String relativePath, ZipEntry zipEntry) {
            super(root, hdf5ContainerFile);
            this.zipFile = zipFile;
            this.relativePath = relativePath;
            this.zipEntry = zipEntry;
        }

        private synchronized void lazyLoad() {
            if (!this.loaded) {
                this.copyZipEntryToFile(this.file);
                this.loaded = true;
            }
        }

        private void copyZipEntryToFile(File tempFile) {
            InputStream in = null;
            FileOutputStream out = null;
            BufferedOutputStream bufferedOut = null;
            try {
                in = this.zipFile.getInputStream(this.zipEntry);
                out = new FileOutputStream(tempFile);
                bufferedOut = new BufferedOutputStream(out);
                IOUtils.copy((InputStream)in, (OutputStream)bufferedOut);
            }
            catch (Exception ex) {
                try {
                    throw CheckedExceptionTunnel.wrapIfNecessary(ex);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(in);
                    IOUtils.closeQuietly(bufferedOut);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((InputStream)in);
            IOUtils.closeQuietly((OutputStream)bufferedOut);
        }

        @Override
        public String doGetRelativePath() {
            return this.relativePath;
        }

        @Override
        public String getName() {
            return ZipBasedHierarchicalContent.extractName(this.relativePath);
        }

        @Override
        public InputStream doGetInputStream() {
            this.lazyLoad();
            return super.doGetInputStream();
        }

        @Override
        protected IHDF5ContainerReader createReader() {
            this.lazyLoad();
            return super.createReader();
        }

        @Override
        public long getLastModified() {
            return this.zipEntry.getTime();
        }

        @Override
        public long doGetFileLength() {
            return this.zipEntry.getSize();
        }

        @Override
        protected int doGetChecksumCRC32() {
            return (int)this.zipEntry.getCrc();
        }

        @Override
        public File getFile() {
            this.lazyLoad();
            return super.getFile();
        }

        @Override
        public boolean isChecksumCRC32Precalculated() {
            return true;
        }

        @Override
        public File tryGetFile() {
            this.lazyLoad();
            return super.tryGetFile();
        }

        @Override
        public IRandomAccessFile doGetFileContent() {
            this.lazyLoad();
            return super.doGetFileContent();
        }
    }

    private static final class ZipContentNode
    extends AbstractHierarchicalFileContentNode {
        private final BasicZipFile zipFile;
        private final ZipEntry zipEntry;
        private final String relativePathFromZipEntry;
        private final String name;

        ZipContentNode(BasicZipFile zipFile, ZipEntry zipEntry) {
            this.zipFile = zipFile;
            this.zipEntry = zipEntry;
            this.relativePathFromZipEntry = zipEntry.getName();
            this.name = ZipBasedHierarchicalContent.extractName(this.relativePathFromZipEntry);
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public boolean exists() {
            return true;
        }

        @Override
        public boolean isDirectory() {
            return false;
        }

        @Override
        public long getLastModified() {
            return this.zipEntry.getTime();
        }

        @Override
        public File getFile() throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }

        @Override
        public File tryGetFile() {
            return null;
        }

        @Override
        protected String doGetRelativePath() {
            return this.relativePathFromZipEntry;
        }

        @Override
        protected long doGetFileLength() {
            return this.zipEntry.getSize();
        }

        @Override
        public boolean isChecksumCRC32Precalculated() {
            return true;
        }

        @Override
        protected int doGetChecksumCRC32() {
            return (int)this.zipEntry.getCrc();
        }

        @Override
        protected IRandomAccessFile doGetFileContent() {
            throw new UnsupportedOperationException();
        }

        @Override
        protected InputStream doGetInputStream() {
            try {
                return this.zipFile.getInputStream(this.zipEntry);
            }
            catch (IOException ex) {
                throw CheckedExceptionTunnel.wrapIfNecessary(ex);
            }
        }
    }

    private static final class ZipContainerNode
    extends AbstractHierarchicalDirectoryContentNode {
        private final String relativePathFromZipEntry;
        private final String name;
        private final List<IHierarchicalContentNode> children = new ArrayList<IHierarchicalContentNode>();

        ZipContainerNode(String relativePath) {
            this.relativePathFromZipEntry = relativePath;
            this.name = ZipBasedHierarchicalContent.extractName(relativePath);
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public boolean exists() {
            return true;
        }

        @Override
        public boolean isDirectory() {
            return true;
        }

        @Override
        public long getLastModified() {
            return 0L;
        }

        @Override
        public File getFile() throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }

        @Override
        public File tryGetFile() {
            return null;
        }

        @Override
        public boolean isChecksumCRC32Precalculated() {
            return true;
        }

        @Override
        protected String doGetRelativePath() {
            return this.relativePathFromZipEntry;
        }

        @Override
        protected List<IHierarchicalContentNode> doGetChildNodes() {
            return new ArrayList<IHierarchicalContentNode>(this.children);
        }
    }
}

